/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tcp.netty;

import io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.OverloadException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.io.IConnection;
import org.jdiameter.client.api.io.IConnectionListener;
import org.jdiameter.client.api.io.TransportError;
import org.jdiameter.client.api.io.TransportException;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.transport.tcp.netty.TCPTransportClient;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPClientConnection
implements IConnection {
    private static Logger logger = LoggerFactory.getLogger(TCPClientConnection.class);
    private final long createdTime = System.currentTimeMillis();
    private TCPTransportClient client;
    private LinkedBlockingQueue<Event> buffer = new LinkedBlockingQueue(64);
    private IMessageParser parser;
    private Lock lock = new ReentrantLock();
    private ConcurrentLinkedQueue<IConnectionListener> listeners = new ConcurrentLinkedQueue();
    private String cachedKey = null;

    public TCPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IMessageParser parser, String ref) {
        this.parser = parser;
        this.client = new TCPTransportClient(this, parser, new InetSocketAddress(remoteAddress, remotePort), new InetSocketAddress(localAddress, localPort));
    }

    public TCPClientConnection(Configuration config, IConcurrentFactory concurrentFactory, InetAddress remoteAddress, int remotePort, InetAddress localAddress, int localPort, IConnectionListener listener, IMessageParser parser, String ref) {
        this(config, concurrentFactory, remoteAddress, remotePort, localAddress, localPort, parser, ref);
        this.listeners.add(listener);
    }

    public TCPClientConnection(Channel channel, IMessageParser parser) {
        this.parser = parser;
        this.client = new TCPTransportClient(this, parser, channel);
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public void connect() throws TransportException {
        try {
            this.client.start();
        }
        catch (Exception e) {
            throw new TransportException("Cannot init transport: ", TransportError.Internal, e);
        }
    }

    @Override
    public void disconnect() throws InternalError {
        logger.debug("In disconnect for [{}]", (Object)this.getKey());
        try {
            if (this.client != null) {
                this.client.stop();
            }
        }
        catch (Exception e) {
            throw new InternalError("Error while stopping transport: " + e.getMessage());
        }
    }

    @Override
    public void release() throws IOException {
        logger.debug("In release for [{}]", (Object)this.getKey());
        try {
            block4: {
                try {
                    if (this.client == null) break block4;
                    this.client.release();
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            Object var3_1 = null;
            this.parser = null;
            this.buffer.clear();
            this.remAllConnectionListener();
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.parser = null;
            this.buffer.clear();
            this.remAllConnectionListener();
            throw throwable;
        }
    }

    @Override
    public void sendMessage(IMessage message) throws TransportException, OverloadException {
        try {
            if (this.client != null) {
                this.client.sendMessage(message);
            }
        }
        catch (Exception e) {
            throw new TransportException("Cannot send message: ", TransportError.FailedSendMessage, e);
        }
    }

    protected TCPTransportClient getClient() {
        return this.client;
    }

    @Override
    public boolean isNetworkInitiated() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.client != null && this.client.isConnected();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.client.getDestAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this.client.getDestAddress().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
            if (this.buffer.size() != 0) {
                for (Event e : this.buffer) {
                    try {
                        logger.debug("Processing event from buffer");
                        this.onEvent(e);
                    }
                    catch (AvpDataException e1) {}
                }
                this.buffer.clear();
            }
            Object var6_5 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remAllConnectionListener() {
        logger.debug("Waiting to get lock in order to remove all listeners");
        this.lock.lock();
        try {
            logger.debug("Removing all listeners on [{}]", (Object)this.getKey());
            this.listeners.clear();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remConnectionListener(IConnectionListener listener) {
        this.lock.lock();
        try {
            logger.debug("Removing listener [{}] on [{}]", (Object)listener.getClass().getName(), (Object)this.getKey());
            this.listeners.remove(listener);
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public boolean isWrapperFor(Class<?> aClass) throws InternalException {
        return false;
    }

    public <T> T unwrap(Class<T> aClass) throws InternalException {
        return null;
    }

    @Override
    public String getKey() {
        if (this.cachedKey == null) {
            this.cachedKey = new StringBuffer("aaa://").append(this.getRemoteAddress().getHostName()).append(":").append(this.getRemotePort()).toString();
        }
        return this.cachedKey;
    }

    protected void onDisconnect() throws AvpDataException {
        this.onEvent(new Event(EventType.DISCONNECTED));
    }

    protected void onMessageReceived(IMessage message) throws AvpDataException {
        this.onEvent(new Event(EventType.MESSAGE_RECEIVED, message));
    }

    protected void onAvpDataException(AvpDataException e) {
        try {
            this.onEvent(new Event(EventType.DATA_EXCEPTION, (Exception)((Object)e)));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    protected void onConnected() {
        try {
            this.onEvent(new Event(EventType.CONNECTED));
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEvent(Event event) throws AvpDataException {
        logger.debug("In onEvent for connection [{}]. Getting lock", (Object)this.getKey());
        this.lock.lock();
        logger.debug("Got lock");
        try {
            if (this.processBufferedMessages(event)) {
                for (IConnectionListener listener : this.listeners) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Passing event to listener. Event type is [{}]", (Object)event.type.toString());
                    }
                    switch (event.type) {
                        case CONNECTED: {
                            listener.connectionOpened(this.getKey());
                            break;
                        }
                        case DISCONNECTED: {
                            listener.connectionClosed(this.getKey(), null);
                            break;
                        }
                        case MESSAGE_RECEIVED: {
                            listener.messageReceived(this.getKey(), event.message);
                            break;
                        }
                        case DATA_EXCEPTION: {
                            listener.internalError(this.getKey(), null, new TransportException("Avp Data Exception:", TransportError.ReceivedBrokenMessage, event.exception));
                        }
                    }
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            logger.debug("Releasing lock and finished onEvent for connection [{}]", (Object)this.getKey());
            this.lock.unlock();
            throw throwable;
        }
        logger.debug("Releasing lock and finished onEvent for connection [{}]", (Object)this.getKey());
        this.lock.unlock();
    }

    protected boolean processBufferedMessages(Event event) throws AvpDataException {
        if (this.listeners.size() == 0) {
            logger.debug("listeners.size() == 0 on connection [{}]", (Object)this.getKey());
            try {
                this.buffer.add(event);
            }
            catch (IllegalStateException e) {
                logger.debug("Got IllegalStateException in processBufferedMessages");
                Event[] tempBuffer = this.buffer.toArray(new Event[this.buffer.size()]);
                this.buffer.remove(tempBuffer[tempBuffer.length - 1]);
                this.buffer.add(event);
            }
            logger.debug("processBufferedMessages is returning false");
            return false;
        }
        logger.debug("processBufferedMessages is returning true on connection [{}] as there are listeners", (Object)this.getKey());
        return true;
    }

    private static class Event {
        EventType type;
        IMessage message;
        Exception exception;

        Event(EventType type) {
            this.type = type;
        }

        Event(EventType type, Exception exception) {
            this(type);
            this.exception = exception;
        }

        Event(EventType type, IMessage message) {
            this(type);
            this.message = message;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        CONNECTED,
        DISCONNECTED,
        MESSAGE_RECEIVED,
        DATA_EXCEPTION;

    }
}

