/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.transport.tcp.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.impl.transport.tcp.netty.TCPClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiameterMessageHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(DiameterMessageHandler.class);
    protected final TCPClientConnection parentConnection;

    public DiameterMessageHandler(TCPClientConnection parentConnection) {
        this.parentConnection = parentConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        logger.debug("Received message TCP Transport from [{}]", (Object)ctx.channel().remoteAddress());
        IMessage m = (IMessage)msg;
        try {
            try {
                logger.debug("Passing message on to parent");
                this.parentConnection.onMessageReceived(m);
                logger.debug("Finished passing message on to parent");
            }
            catch (AvpDataException e) {
                logger.debug("Garbage was received. Discarding.");
                this.parentConnection.onAvpDataException(e);
                Object var6_5 = null;
                ReferenceCountUtil.release((Object)m);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ReferenceCountUtil.release((Object)m);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)m);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error(cause.getMessage(), cause);
    }
}

