/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.helpers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class IPConverter {
    public static InetAddress InetAddressByIPv4(String address) {
        StringTokenizer addressTokens = new StringTokenizer(address, ".");
        if (addressTokens.countTokens() != 4) {
            return null;
        }
        byte[] bytes = new byte[]{IPConverter.getByBytes(addressTokens), IPConverter.getByBytes(addressTokens), IPConverter.getByBytes(addressTokens), IPConverter.getByBytes(addressTokens)};
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static byte getByBytes(StringTokenizer addressTokens) {
        int word = Integer.parseInt(addressTokens.nextToken());
        return (byte)(word & 0xFF);
    }

    public static InetAddress InetAddressByIPv6(String address) {
        StringTokenizer addressTokens = new StringTokenizer(address, ":");
        byte[] bytes = new byte[16];
        if (addressTokens.countTokens() == 8) {
            int count = 0;
            while (addressTokens.hasMoreTokens()) {
                int word = Integer.parseInt(addressTokens.nextToken(), 16);
                bytes[count * 2] = (byte)(word >> 8 & 0xFF);
                bytes[count * 2 + 1] = (byte)(word & 0xFF);
                ++count;
            }
        } else {
            return null;
        }
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

