/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.gx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jdiameter.api.Answer;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.gx.ClientGxSession;
import org.jdiameter.api.gx.ClientGxSessionListener;
import org.jdiameter.api.gx.events.GxCreditControlAnswer;
import org.jdiameter.api.gx.events.GxCreditControlRequest;
import org.jdiameter.api.gx.events.GxReAuthAnswer;
import org.jdiameter.api.gx.events.GxReAuthRequest;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.impl.app.gx.Event;
import org.jdiameter.client.impl.app.gx.IClientGxSessionData;
import org.jdiameter.common.api.app.gx.ClientGxSessionState;
import org.jdiameter.common.api.app.gx.IClientGxSessionContext;
import org.jdiameter.common.api.app.gx.IGxMessageFactory;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.gx.AppGxSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientGxSessionImpl
extends AppGxSessionImpl
implements ClientGxSession,
NetworkReqListener,
EventListener<Request, Answer> {
    private static final Logger logger = LoggerFactory.getLogger(ClientGxSessionImpl.class);
    protected IClientGxSessionData sessionData;
    protected Lock sendAndStateLock = new ReentrantLock();
    protected IGxMessageFactory factory;
    protected ClientGxSessionListener listener;
    protected IClientGxSessionContext context;
    protected IMessageParser parser;
    protected static final String TX_TIMER_NAME = "Gx_CLIENT_TX_TIMER";
    protected static final long TX_TIMER_DEFAULT_VALUE = 1800000L;
    protected long[] authAppIds = new long[]{4L};
    protected static final int CCFH_TERMINATE = 0;
    protected static final int CCFH_CONTINUE = 1;
    protected static final int CCFH_RETRY_AND_TERMINATE = 2;
    private static final int DDFH_TERMINATE_OR_BUFFER = 0;
    private static final int DDFH_CONTINUE = 1;
    private static final int DIRECT_DEBITING = 0;
    private static final int REFUND_ACCOUNT = 1;
    private static final int CHECK_BALANCE = 2;
    private static final int PRICE_ENQUIRY = 3;
    private static final int EVENT_REQUEST = 4;
    private static final long END_USER_SERVICE_DENIED = 4010L;
    private static final long CREDIT_CONTROL_NOT_APPLICABLE = 4011L;
    private static final long USER_UNKNOWN = 5030L;
    private static final long DIAMETER_UNABLE_TO_DELIVER = 3002L;
    private static final long DIAMETER_TOO_BUSY = 3004L;
    private static final long DIAMETER_LOOP_DETECTED = 3005L;
    protected static final Set<Long> temporaryErrorCodes;
    protected ArrayList<Event> eventQueue = new ArrayList();

    public ClientGxSessionImpl(IClientGxSessionData sessionData, IGxMessageFactory fct, ISessionFactory sf, ClientGxSessionListener lst, IClientGxSessionContext ctx, StateChangeListener<AppSession> stLst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationIds() == null) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.context = ctx;
        this.authAppIds = fct.getApplicationIds();
        this.listener = lst;
        this.factory = fct;
        IContainer icontainer = sf.getContainer();
        this.parser = icontainer.getAssemblerFacility().getComponentInstance(IMessageParser.class);
        this.sessionData = sessionData;
        super.addStateChangeNotification(stLst);
    }

    protected int getLocalCCFH() {
        return this.sessionData.getGatheredCCFH() >= 0 ? this.sessionData.getGatheredCCFH() : this.context.getDefaultCCFHValue();
    }

    protected int getLocalDDFH() {
        return this.sessionData.getGatheredDDFH() >= 0 ? this.sessionData.getGatheredDDFH() : this.context.getDefaultDDFHValue();
    }

    public void sendCreditControlRequest(GxCreditControlRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        try {
            this.extractFHAVPs(request, null);
            this.handleEvent(new Event(true, request, null));
        }
        catch (AvpDataException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void sendGxReAuthAnswer(GxReAuthAnswer answer) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.handleEvent(new Event(Event.Type.SEND_RAA, null, (AppAnswerEvent)answer));
    }

    public boolean isStateless() {
        return false;
    }

    public boolean isEventBased() {
        return this.sessionData.isEventBased();
    }

    public <E> E getState(Class<E> stateType) {
        return (E)(stateType == ClientGxSessionState.class ? this.sessionData.getClientGxSessionState() : null);
    }

    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        return this.isEventBased() ? this.handleEventForEventBased(event) : this.handleEventForSessionBased(event);
    }

    protected boolean handleEventForEventBased(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            ClientGxSessionState state = this.sessionData.getClientGxSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            block4 : switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_EVENT_REQUEST: {
                            this.startTx((GxCreditControlRequest)localEvent.getRequest());
                            this.setState(ClientGxSessionState.PENDING_EVENT);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                logger.debug("Failure handling send event request", (Throwable)e);
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block4;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_EVENT: {
                    switch (eventType) {
                        case RECEIVE_EVENT_ANSWER: {
                            AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                            try {
                                long resultCode = answer.getResultCodeAvp().getUnsigned32();
                                if (this.isSuccess(resultCode)) {
                                    this.setState(ClientGxSessionState.IDLE, false);
                                }
                                if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                    this.handleFailureMessage((GxCreditControlAnswer)answer, (GxCreditControlRequest)localEvent.getRequest(), eventType);
                                }
                                this.deliverGxAnswer((GxCreditControlRequest)localEvent.getRequest(), (GxCreditControlAnswer)localEvent.getAnswer());
                            }
                            catch (AvpDataException e) {
                                logger.debug("Failure handling received answer event", (Throwable)e);
                                this.setState(ClientGxSessionState.IDLE, false);
                            }
                            break block4;
                        }
                        case Tx_TIMER_FIRED: {
                            this.handleTxExpires(localEvent.getRequest().getMessage());
                            break block4;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_BUFFERED: {
                    switch (eventType) {
                        case RECEIVE_EVENT_ANSWER: {
                            this.setState(ClientGxSessionState.IDLE, false);
                            this.sessionData.setBuffer(null);
                            this.deliverGxAnswer((GxCreditControlRequest)localEvent.getRequest(), (GxCreditControlAnswer)localEvent.getAnswer());
                            break block4;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                default: {
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                }
            }
            this.dispatch();
            boolean bl = true;
            Object var9_11 = null;
            this.sendAndStateLock.unlock();
            return bl;
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    protected boolean handleEventForSessionBased(StateEvent event) throws InternalException, OverloadException {
        try {
            this.sendAndStateLock.lock();
            ClientGxSessionState state = this.sessionData.getClientGxSessionState();
            Event localEvent = (Event)event;
            Event.Type eventType = (Event.Type)localEvent.getType();
            block8 : switch (state) {
                case IDLE: {
                    switch (eventType) {
                        case SEND_INITIAL_REQUEST: {
                            this.startTx((GxCreditControlRequest)localEvent.getRequest());
                            this.setState(ClientGxSessionState.PENDING_INITIAL);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_INITIAL: {
                    AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                    switch (eventType) {
                        case RECEIVED_INITIAL_ANSWER: {
                            long resultCode = answer.getResultCodeAvp().getUnsigned32();
                            if (this.isSuccess(resultCode)) {
                                this.stopTx();
                                this.setState(ClientGxSessionState.OPEN);
                            } else if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                this.handleFailureMessage((GxCreditControlAnswer)answer, (GxCreditControlRequest)localEvent.getRequest(), eventType);
                            }
                            this.deliverGxAnswer((GxCreditControlRequest)localEvent.getRequest(), (GxCreditControlAnswer)localEvent.getAnswer());
                            break block8;
                        }
                        case Tx_TIMER_FIRED: {
                            this.handleTxExpires(localEvent.getRequest().getMessage());
                            break block8;
                        }
                        case SEND_UPDATE_REQUEST: 
                        case SEND_TERMINATE_REQUEST: {
                            this.eventQueue.add(localEvent);
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case OPEN: {
                    switch (eventType) {
                        case SEND_UPDATE_REQUEST: {
                            this.startTx((GxCreditControlRequest)localEvent.getRequest());
                            this.setState(ClientGxSessionState.PENDING_UPDATE);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                        case SEND_TERMINATE_REQUEST: {
                            this.setState(ClientGxSessionState.PENDING_TERMINATION);
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                        case RECEIVED_RAR: {
                            this.deliverRAR((GxReAuthRequest)localEvent.getRequest());
                            break block8;
                        }
                        case SEND_RAA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                case PENDING_UPDATE: {
                    AppAnswerEvent answer = (AppAnswerEvent)localEvent.getAnswer();
                    switch (eventType) {
                        case RECEIVED_UPDATE_ANSWER: {
                            long resultCode = answer.getResultCodeAvp().getUnsigned32();
                            if (this.isSuccess(resultCode)) {
                                this.stopTx();
                                this.setState(ClientGxSessionState.OPEN);
                            } else if (this.isProvisional(resultCode) || this.isFailure(resultCode)) {
                                this.handleFailureMessage((GxCreditControlAnswer)answer, (GxCreditControlRequest)localEvent.getRequest(), eventType);
                            }
                            this.deliverGxAnswer((GxCreditControlRequest)localEvent.getRequest(), (GxCreditControlAnswer)localEvent.getAnswer());
                            break;
                        }
                        case Tx_TIMER_FIRED: {
                            this.handleTxExpires(localEvent.getRequest().getMessage());
                            break;
                        }
                        case SEND_UPDATE_REQUEST: 
                        case SEND_TERMINATE_REQUEST: {
                            this.eventQueue.add(localEvent);
                            break;
                        }
                        case RECEIVED_RAR: {
                            this.deliverRAR((GxReAuthRequest)localEvent.getRequest());
                            break;
                        }
                        case SEND_RAA: {
                            try {
                                this.dispatchEvent(localEvent.getAnswer());
                                break;
                            }
                            catch (Exception e) {
                                this.handleSendFailure(e, eventType, localEvent.getRequest().getMessage());
                            }
                        }
                    }
                    break;
                }
                case PENDING_TERMINATION: {
                    switch (eventType) {
                        case SEND_UPDATE_REQUEST: {
                            try {
                                this.dispatchEvent(localEvent.getRequest());
                            }
                            catch (Exception e) {}
                            break block8;
                        }
                        case RECEIVED_TERMINATED_ANSWER: {
                            this.deliverGxAnswer((GxCreditControlRequest)localEvent.getRequest(), (GxCreditControlAnswer)localEvent.getAnswer());
                            this.setState(ClientGxSessionState.IDLE, true);
                            break block8;
                        }
                    }
                    logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    break;
                }
                default: {
                    this.setState(ClientGxSessionState.IDLE, true);
                }
            }
            this.dispatch();
            boolean bl = true;
            Object var10_16 = null;
            this.sendAndStateLock.unlock();
            return bl;
        }
        catch (Exception e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var10_17 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery ad = new AnswerDelivery();
        ad.session = this;
        ad.request = request;
        ad.answer = answer;
        this.scheduler.execute(ad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeoutExpired(Request request) {
        if (request.getCommandCode() == 272) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    this.handleSendFailure(null, null, (Message)request);
                }
                catch (Exception e) {
                    logger.debug("Failure processing timeout message for request", (Throwable)e);
                    Object var4_3 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var4_2 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    protected void startTx(GxCreditControlRequest request) {
        long txTimerValue = this.context.getDefaultTxTimerValue();
        if (txTimerValue < 0L) {
            txTimerValue = 1800000L;
        }
        this.stopTx();
        logger.debug("Scheduling TX Timer {}", (Object)txTimerValue);
        try {
            this.sessionData.setTxTimerRequest((Request)request.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to store request.", e);
        }
        this.sessionData.setTxTimerId(this.timerFacility.schedule(this.getSessionId(), TX_TIMER_NAME, 1800000L));
    }

    protected void stopTx() {
        Serializable txTimerId = this.sessionData.getTxTimerId();
        if (txTimerId != null) {
            this.timerFacility.cancel(txTimerId);
            this.sessionData.setTxTimerRequest(null);
            this.sessionData.setTxTimerId(null);
        }
    }

    @Override
    public void onTimer(String timerName) {
        if (timerName.equals(TX_TIMER_NAME)) {
            new TxTimerTask(this, this.sessionData.getTxTimerRequest()).run();
        }
    }

    protected void setState(ClientGxSessionState newState) {
        this.setState(newState, true);
    }

    protected void setState(ClientGxSessionState newState, boolean release) {
        block5: {
            try {
                ClientGxSessionState oldState = this.sessionData.getClientGxSessionState();
                this.sessionData.setClientGxSessionState(newState);
                for (StateChangeListener i : this.stateListeners) {
                    i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
                }
                if (newState == ClientGxSessionState.IDLE) {
                    if (release) {
                        this.release();
                    }
                    this.stopTx();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Failure switching to state " + this.sessionData.getClientGxSessionState() + " (release=" + release + ")", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    this.stopTx();
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSendFailure(Exception e, Event.Type eventType, Message request) throws Exception {
        logger.debug("Failed to send message, type: {} message: {}, failure: {}", new Object[]{eventType, request, e != null ? e.getLocalizedMessage() : ""});
        try {
            ClientGxSessionState state = this.sessionData.getClientGxSessionState();
            if (this.isEventBased()) {
                int gatheredRequestedAction = this.sessionData.getGatheredRequestedAction();
                block1 : switch (state) {
                    case PENDING_EVENT: {
                        if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                            this.setState(ClientGxSessionState.IDLE);
                            this.context.indicateServiceError(this);
                            break;
                        }
                        if (gatheredRequestedAction == 0) {
                            switch (this.getLocalDDFH()) {
                                case 0: {
                                    request.setReTransmitted(true);
                                    this.sessionData.setBuffer((Request)request);
                                    this.setState(ClientGxSessionState.IDLE, false);
                                    break block1;
                                }
                                case 1: {
                                    this.context.grantAccessOnDeliverFailure(this, request);
                                    break block1;
                                }
                            }
                            logger.warn("Invalid Direct-Debiting-Failure-Handling AVP value {}", (Object)this.getLocalDDFH());
                            break;
                        }
                        if (gatheredRequestedAction == 1) {
                            this.setState(ClientGxSessionState.IDLE, false);
                            request.setReTransmitted(true);
                            this.sessionData.setBuffer((Request)request);
                            break;
                        }
                        logger.warn("Invalid Requested-Action AVP value {}", (Object)gatheredRequestedAction);
                        break;
                    }
                    case PENDING_BUFFERED: {
                        this.setState(ClientGxSessionState.IDLE, false);
                        this.sessionData.setBuffer(null);
                        break;
                    }
                    default: {
                        logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                        break;
                    }
                }
            } else {
                switch (this.getLocalCCFH()) {
                    case 1: {
                        this.setState(ClientGxSessionState.IDLE, false);
                        this.context.grantAccessOnDeliverFailure(this, request);
                        break;
                    }
                    default: {
                        this.context.denyAccessOnDeliverFailure(this, request);
                        this.setState(ClientGxSessionState.IDLE, true);
                    }
                }
            }
            Object var7_6 = null;
            this.dispatch();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.dispatch();
            throw throwable;
        }
    }

    protected void handleFailureMessage(GxCreditControlAnswer event, GxCreditControlRequest request, Event.Type eventType) {
        block38: {
            try {
                ClientGxSessionState state = this.sessionData.getClientGxSessionState();
                Serializable txTimerId = this.sessionData.getTxTimerId();
                long resultCode = event.getResultCodeAvp().getUnsigned32();
                if (this.isEventBased()) {
                    int gatheredRequestedAction = this.sessionData.getGatheredRequestedAction();
                    switch (state) {
                        case PENDING_EVENT: {
                            if (resultCode == 4010L || resultCode == 5030L) {
                                if (this.sessionData.getTxTimerId() != null) {
                                    this.context.denyAccessOnFailureMessage(this);
                                    this.deliverGxAnswer(request, event);
                                    this.setState(ClientGxSessionState.IDLE);
                                    break;
                                }
                                if (gatheredRequestedAction == 0 && txTimerId == null) {
                                    this.setState(ClientGxSessionState.IDLE);
                                    break;
                                }
                                break block38;
                            }
                            if (resultCode == 4011L && gatheredRequestedAction == 0) {
                                this.context.grantAccessOnFailureMessage(this);
                                this.deliverGxAnswer(request, event);
                                this.setState(ClientGxSessionState.IDLE);
                                break;
                            }
                            if (temporaryErrorCodes.contains(resultCode)) {
                                if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                                    this.context.indicateServiceError(this);
                                    this.deliverGxAnswer(request, event);
                                    this.setState(ClientGxSessionState.IDLE);
                                    break;
                                }
                                if (gatheredRequestedAction == 0) {
                                    if (this.getLocalDDFH() == 1) {
                                        this.context.grantAccessOnFailureMessage(this);
                                        this.deliverGxAnswer(request, event);
                                        this.setState(ClientGxSessionState.IDLE);
                                        break;
                                    }
                                    if (this.getLocalDDFH() == 0 && txTimerId != null) {
                                        this.context.denyAccessOnFailureMessage(this);
                                        this.deliverGxAnswer(request, event);
                                        this.setState(ClientGxSessionState.IDLE);
                                        break;
                                    }
                                    break block38;
                                }
                                if (gatheredRequestedAction == 1) {
                                    this.sessionData.setBuffer((Request)request.getMessage());
                                    this.setState(ClientGxSessionState.IDLE, false);
                                    break;
                                }
                                logger.warn("Invalid combination for Ro Client FSM: State {}, Result-Code {}, Requested-Action {}, DDFH {}, Tx {}", new Object[]{state, resultCode, gatheredRequestedAction, this.getLocalDDFH(), txTimerId});
                                break;
                            }
                            if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                                this.context.indicateServiceError(this);
                                this.deliverGxAnswer(request, event);
                                this.setState(ClientGxSessionState.IDLE);
                                break;
                            }
                            if (gatheredRequestedAction == 0) {
                                if (this.getLocalDDFH() == 1) {
                                    this.context.grantAccessOnFailureMessage(this);
                                    this.deliverGxAnswer(request, event);
                                    this.setState(ClientGxSessionState.IDLE);
                                    break;
                                }
                                if (this.getLocalDDFH() == 0 && txTimerId != null) {
                                    this.context.denyAccessOnFailureMessage(this);
                                    this.deliverGxAnswer(request, event);
                                    this.setState(ClientGxSessionState.IDLE);
                                    break;
                                }
                                break block38;
                            }
                            if (gatheredRequestedAction == 1) {
                                this.sessionData.setBuffer(null);
                                this.context.indicateServiceError(this);
                                this.deliverGxAnswer(request, event);
                                this.setState(ClientGxSessionState.IDLE);
                                break;
                            }
                            logger.warn("Invalid combination for Ro Client FSM: State {}, Result-Code {}, Requested-Action {}, DDFH {}, Tx {}", new Object[]{state, resultCode, gatheredRequestedAction, this.getLocalDDFH(), txTimerId});
                            break;
                        }
                        case PENDING_BUFFERED: {
                            this.sessionData.setBuffer(null);
                            this.setState(ClientGxSessionState.IDLE, false);
                            break;
                        }
                        default: {
                            logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                            break;
                        }
                    }
                    break block38;
                }
                block5 : switch (state) {
                    case PENDING_INITIAL: {
                        if (resultCode == 4011L) {
                            this.context.grantAccessOnFailureMessage(this);
                            this.setState(ClientGxSessionState.IDLE, false);
                            break;
                        }
                        if (resultCode == 4010L || resultCode == 5030L) {
                            this.context.denyAccessOnFailureMessage(this);
                            this.setState(ClientGxSessionState.IDLE, false);
                            break;
                        }
                        switch (this.getLocalCCFH()) {
                            case 1: {
                                this.context.grantAccessOnFailureMessage(this);
                                this.setState(ClientGxSessionState.IDLE, false);
                                break block5;
                            }
                            case 0: 
                            case 2: {
                                this.context.denyAccessOnFailureMessage(this);
                                this.setState(ClientGxSessionState.IDLE, false);
                                break block5;
                            }
                        }
                        logger.warn("Invalid value for CCFH: {}", (Object)this.getLocalCCFH());
                        break;
                    }
                    case PENDING_UPDATE: {
                        if (resultCode == 4011L) {
                            this.context.grantAccessOnFailureMessage(this);
                            this.setState(ClientGxSessionState.IDLE, false);
                            break;
                        }
                        if (resultCode == 4010L) {
                            this.context.denyAccessOnFailureMessage(this);
                            this.setState(ClientGxSessionState.IDLE, false);
                            break;
                        }
                        switch (this.getLocalCCFH()) {
                            case 1: {
                                this.context.grantAccessOnFailureMessage(this);
                                this.setState(ClientGxSessionState.IDLE, false);
                                break block5;
                            }
                            case 0: 
                            case 2: {
                                this.context.denyAccessOnFailureMessage(this);
                                this.setState(ClientGxSessionState.IDLE, false);
                                break block5;
                            }
                        }
                        logger.warn("Invalid value for CCFH: " + this.getLocalCCFH());
                        break;
                    }
                    default: {
                        logger.warn("Wrong event type ({}) on state {}", (Object)eventType, (Object)state);
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block38;
                logger.debug("Failure handling failure message for Event " + event + " (" + (Object)((Object)eventType) + ") and Request " + request, (Throwable)e);
            }
        }
    }

    protected void handleTxExpires(Message message) {
        ClientGxSessionState state = this.sessionData.getClientGxSessionState();
        if (this.isEventBased()) {
            int gatheredRequestedAction = this.sessionData.getGatheredRequestedAction();
            if (gatheredRequestedAction == 2 || gatheredRequestedAction == 3) {
                this.context.indicateServiceError(this);
                this.setState(ClientGxSessionState.IDLE);
            } else if (gatheredRequestedAction == 0) {
                int gatheredDDFH = this.sessionData.getGatheredDDFH();
                if (gatheredDDFH == 0) {
                    this.sessionData.setBuffer((Request)message);
                    this.setState(ClientGxSessionState.IDLE, false);
                } else {
                    this.context.grantAccessOnTxExpire(this);
                    this.setState(ClientGxSessionState.PENDING_EVENT);
                }
            } else if (gatheredRequestedAction == 1) {
                message.setReTransmitted(true);
                this.sessionData.setBuffer((Request)message);
                this.setState(ClientGxSessionState.IDLE, false);
            }
        } else {
            block0 : switch (state) {
                case PENDING_INITIAL: {
                    switch (this.getLocalCCFH()) {
                        case 1: 
                        case 2: {
                            this.context.grantAccessOnTxExpire(this);
                            break block0;
                        }
                        case 0: {
                            this.context.denyAccessOnTxExpire(this);
                            this.setState(ClientGxSessionState.IDLE, true);
                            break block0;
                        }
                    }
                    logger.warn("Invalid value for CCFH: " + this.getLocalCCFH());
                    break;
                }
                case PENDING_UPDATE: {
                    switch (this.getLocalCCFH()) {
                        case 1: 
                        case 2: {
                            this.context.grantAccessOnTxExpire(this);
                            break block0;
                        }
                        case 0: {
                            this.context.denyAccessOnTxExpire(this);
                            this.setState(ClientGxSessionState.IDLE, true);
                            break block0;
                        }
                    }
                    logger.error("Bad value of CCFH: " + this.getLocalCCFH());
                    break;
                }
                default: {
                    logger.error("Unknown state (" + state + ") on txExpire");
                }
            }
        }
    }

    protected void dispatch() {
        if (this.isEventBased()) {
            Request buffer = this.sessionData.getBuffer();
            if (buffer != null) {
                this.setState(ClientGxSessionState.PENDING_BUFFERED);
                try {
                    this.dispatchEvent(new AppRequestEventImpl((Message)buffer));
                }
                catch (Exception e) {
                    try {
                        this.handleSendFailure(e, Event.Type.SEND_EVENT_REQUEST, (Message)buffer);
                    }
                    catch (Exception e1) {
                        logger.error("Failure handling buffer send failure", (Throwable)e1);
                    }
                }
            }
        } else if (this.sessionData.getClientGxSessionState() == ClientGxSessionState.OPEN && this.eventQueue.size() > 0) {
            try {
                this.handleEvent(this.eventQueue.remove(0));
            }
            catch (Exception e) {
                logger.error("Failure handling queued event", (Throwable)e);
            }
        }
    }

    protected void deliverGxAnswer(GxCreditControlRequest request, GxCreditControlAnswer answer) {
        try {
            this.listener.doCreditControlAnswer((ClientGxSession)this, request, answer);
        }
        catch (Exception e) {
            logger.warn("Failure delivering Ro Answer", (Throwable)e);
        }
    }

    protected void extractFHAVPs(GxCreditControlRequest request, GxCreditControlAnswer answer) throws AvpDataException {
        if (answer != null) {
            try {
                if (answer.isCreditControlFailureHandlingAVPPresent()) {
                    this.sessionData.setGatheredCCFH(answer.getCredidControlFailureHandlingAVPValue());
                }
            }
            catch (Exception e) {
                logger.debug("Failure trying to obtain Credit-Control-Failure-Handling AVP value", (Throwable)e);
            }
            try {
                if (answer.isDirectDebitingFailureHandlingAVPPresent()) {
                    this.sessionData.setGatheredDDFH(answer.getDirectDebitingFailureHandlingAVPValue());
                }
            }
            catch (Exception e) {
                logger.debug("Failure trying to obtain Direct-Debit-Failure-Handling AVP value", (Throwable)e);
            }
            if (!this.sessionData.isRequestTypeSet()) {
                this.sessionData.setRequestTypeSet(true);
                this.sessionData.setEventBased(answer.getRequestTypeAVPValue() == 4);
            }
        } else if (request != null) {
            try {
                if (request.isRequestedActionAVPPresent()) {
                    this.sessionData.setGatheredRequestedAction(request.getRequestedActionAVPValue());
                }
            }
            catch (Exception e) {
                logger.debug("Failure trying to obtain Request-Action AVP value", (Throwable)e);
            }
            if (!this.sessionData.isRequestTypeSet()) {
                this.sessionData.setRequestTypeSet(true);
                this.sessionData.setEventBased(request.getRequestTypeAVPValue() == 4);
            }
        }
    }

    protected void deliverRAR(GxReAuthRequest request) {
        try {
            this.listener.doGxReAuthRequest((ClientGxSession)this, request);
        }
        catch (Exception e) {
            logger.debug("Failure delivering RAR", (Throwable)e);
        }
    }

    protected void dispatchEvent(AppEvent event) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.session.send(event.getMessage(), (EventListener)this);
    }

    protected boolean isProvisional(long resultCode) {
        return resultCode >= 1000L && resultCode < 2000L;
    }

    protected boolean isSuccess(long resultCode) {
        return resultCode >= 2000L && resultCode < 3000L;
    }

    protected boolean isFailure(long code) {
        return !this.isProvisional(code) && !this.isSuccess(code) && code >= 3000L && code < 6000L && !temporaryErrorCodes.contains(code);
    }

    @Override
    public boolean isReplicable() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.sessionData == null ? 0 : this.sessionData.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientGxSessionImpl other = (ClientGxSessionImpl)obj;
        return !(this.sessionData == null ? other.sessionData != null : !this.sessionData.equals(other.sessionData));
    }

    static {
        HashSet<Long> tmp = new HashSet<Long>();
        tmp.add(3002L);
        tmp.add(3004L);
        tmp.add(3005L);
        temporaryErrorCodes = Collections.unmodifiableSet(tmp);
    }

    private class AnswerDelivery
    implements Runnable {
        ClientGxSession session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 272: {
                        GxCreditControlRequest myRequest = ClientGxSessionImpl.this.factory.createCreditControlRequest(this.request);
                        GxCreditControlAnswer myAnswer = ClientGxSessionImpl.this.factory.createCreditControlAnswer(this.answer);
                        ClientGxSessionImpl.this.extractFHAVPs(null, myAnswer);
                        ClientGxSessionImpl.this.handleEvent(new Event(false, myRequest, myAnswer));
                        break;
                    }
                    default: {
                        ClientGxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failure processing success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientGxSession session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    case 258: {
                        ClientGxSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVED_RAR, (AppRequestEvent)ClientGxSessionImpl.this.factory.createGxReAuthRequest(this.request), null));
                        break;
                    }
                    default: {
                        ClientGxSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failure processing request", (Throwable)e);
            }
        }
    }

    private class TxTimerTask
    implements Runnable {
        private ClientGxSession session = null;
        private Request request = null;

        private TxTimerTask(ClientGxSession session, Request request) {
            this.session = session;
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    try {
                        ClientGxSessionImpl.this.sendAndStateLock.lock();
                        logger.debug("Fired TX Timer");
                        ClientGxSessionImpl.this.sessionData.setTxTimerId(null);
                        ClientGxSessionImpl.this.sessionData.setTxTimerRequest(null);
                        try {
                            ClientGxSessionImpl.this.context.txTimerExpired(this.session);
                        }
                        catch (Exception e) {
                            logger.debug("Failure handling TX Timer Expired", (Throwable)e);
                        }
                        GxCreditControlRequest req = ClientGxSessionImpl.this.factory.createCreditControlRequest(this.request);
                        ClientGxSessionImpl.this.handleEvent(new Event(Event.Type.Tx_TIMER_FIRED, (AppRequestEvent)req, null));
                    }
                    catch (InternalException e) {
                        logger.error("Internal Exception", (Throwable)e);
                        Object var3_7 = null;
                        ClientGxSessionImpl.this.sendAndStateLock.unlock();
                        break block8;
                    }
                    catch (OverloadException e) {
                        logger.error("Overload Exception", (Throwable)e);
                        Object var3_8 = null;
                        ClientGxSessionImpl.this.sendAndStateLock.unlock();
                        break block8;
                    }
                    catch (Exception e) {
                        logger.error("Exception", (Throwable)e);
                        Object var3_9 = null;
                        ClientGxSessionImpl.this.sendAndStateLock.unlock();
                    }
                    Object var3_6 = null;
                    ClientGxSessionImpl.this.sendAndStateLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_10 = null;
                    ClientGxSessionImpl.this.sendAndStateLock.unlock();
                    throw throwable;
                }
            }
        }
    }
}

