/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jdiameter.client.impl;

import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Message;
import org.jdiameter.api.MetaData;

/**
 * Small util class to separate AVP manipulation code from MessageParser class.
 * 
 * @author <a href="mailto:baranowb@gmail.com"> Bartosz Baranowski </a>
 */
public class MessageUtility {

  private MessageUtility() {
  }

  /**
   * Used to set origin, previously done in MessageParser.
   * 
   * @param m
   * @param md
   */
  public static void addOriginAvps(Message m, MetaData md) {
    // FIXME: check for "userFqnAsUri" ?
    AvpSet set = m.getAvps();
    if (set.getAvp(Avp.ORIGIN_HOST) == null) {
      m.getAvps().addAvp(Avp.ORIGIN_HOST, md.getLocalPeer().getUri().getFQDN(), true, false, true);
    }
    if (set.getAvp(Avp.ORIGIN_REALM) == null) {
      m.getAvps().addAvp(Avp.ORIGIN_REALM, md.getLocalPeer().getRealmName(), true, false, true);
    }
  }

}
