/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.data;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jdiameter.api.BaseSession;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.common.api.app.IAppSessionData;
import org.jdiameter.common.api.app.IAppSessionDataFactory;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.api.app.acc.IAccSessionData;
import org.jdiameter.common.api.app.auth.IAuthSessionData;
import org.jdiameter.common.api.app.cca.ICCASessionData;
import org.jdiameter.common.api.app.cxdx.ICxDxSessionData;
import org.jdiameter.common.api.app.gx.IGxSessionData;
import org.jdiameter.common.api.app.rf.IRfSessionData;
import org.jdiameter.common.api.app.ro.IRoSessionData;
import org.jdiameter.common.api.app.rx.IRxSessionData;
import org.jdiameter.common.api.app.sh.IShSessionData;
import org.jdiameter.common.api.data.ISessionDatasource;
import org.jdiameter.common.impl.data.LocalDataSource;
import org.mobicents.cache.MobicentsCache;
import org.mobicents.cluster.DataRemovalListener;
import org.mobicents.cluster.DefaultMobicentsCluster;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.cluster.election.ClusterElector;
import org.mobicents.cluster.election.DefaultClusterElector;
import org.mobicents.diameter.impl.ha.common.AppSessionDataReplicatedImpl;
import org.mobicents.diameter.impl.ha.common.acc.AccReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.auth.AuthReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.cca.CCAReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.cxdx.CxDxReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.gx.GxReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.rf.RfReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.ro.RoReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.rx.RxReplicatedSessionDataFactory;
import org.mobicents.diameter.impl.ha.common.sh.ShReplicatedSessionDataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedSessionDatasource
implements ISessionDatasource,
DataRemovalListener {
    private static final Logger logger = LoggerFactory.getLogger(ReplicatedSessionDatasource.class);
    public static final String CLUSTER_DS_DEFAULT_FILE = "jdiameter-jbc.xml";
    private IContainer container;
    private ISessionDatasource localDataSource;
    private DefaultMobicentsCluster mobicentsCluster;
    private boolean localMode;
    protected HashMap<Class<? extends IAppSessionData>, IAppSessionDataFactory<? extends IAppSessionData>> appSessionDataFactories = new HashMap();
    public static final String SESSIONS = "/diameter/appsessions";
    public static final Fqn SESSIONS_FQN = Fqn.fromString((String)"/diameter/appsessions");

    public ReplicatedSessionDatasource(IContainer container) {
        this(container, (ISessionDatasource)new LocalDataSource(), ReplicatedSessionDatasource.class.getClassLoader().getResource(CLUSTER_DS_DEFAULT_FILE) == null ? "config/jdiameter-jbc.xml" : CLUSTER_DS_DEFAULT_FILE);
    }

    public ReplicatedSessionDatasource(IContainer container, ISessionDatasource localDataSource, String cacheConfigFilename) {
        this.localDataSource = localDataSource;
        MobicentsCache mcCache = new MobicentsCache(cacheConfigFilename);
        TransactionManager txMgr = null;
        try {
            Class<?> txMgrClass = Class.forName(mcCache.getJBossCache().getConfiguration().getTransactionManagerLookupClass());
            Object txMgrLookup = txMgrClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            txMgr = (TransactionManager)txMgrClass.getMethod("getTransactionManager", new Class[0]).invoke(txMgrLookup, new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Could not fetch TxMgr. Not using one.", (Throwable)e);
        }
        this.mobicentsCluster = new DefaultMobicentsCluster(mcCache, txMgr, (ClusterElector)new DefaultClusterElector());
        this.mobicentsCluster.addDataRemovalListener((DataRemovalListener)this);
        this.mobicentsCluster.startCluster();
        this.container = container;
        this.appSessionDataFactories.put(IAuthSessionData.class, new AuthReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(IAccSessionData.class, new AccReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(ICCASessionData.class, new CCAReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(IRoSessionData.class, new RoReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(IRfSessionData.class, new RfReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(IShSessionData.class, new ShReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(ICxDxSessionData.class, new CxDxReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(IGxSessionData.class, new GxReplicatedSessionDataFactory(this));
        this.appSessionDataFactories.put(IRxSessionData.class, new RxReplicatedSessionDataFactory(this));
    }

    public boolean exists(String sessionId) {
        return this.localDataSource.exists(sessionId) ? true : this.existReplicated(sessionId);
    }

    public void addSession(BaseSession session) {
        this.localDataSource.addSession(session);
    }

    public BaseSession getSession(String sessionId) {
        if (this.localDataSource.exists(sessionId)) {
            return this.localDataSource.getSession(sessionId);
        }
        if (!this.localMode && this.existReplicated(sessionId)) {
            this.makeLocal(sessionId);
            return this.localDataSource.getSession(sessionId);
        }
        return null;
    }

    public NetworkReqListener getSessionListener(String sessionId) {
        if (this.localDataSource.exists(sessionId)) {
            return this.localDataSource.getSessionListener(sessionId);
        }
        if (!this.localMode && this.existReplicated(sessionId)) {
            this.makeLocal(sessionId);
            return this.localDataSource.getSessionListener(sessionId);
        }
        return null;
    }

    public void removeSession(String sessionId) {
        logger.debug("removeSession({}) in Local DataSource", (Object)sessionId);
        if (this.localDataSource.exists(sessionId)) {
            this.localDataSource.removeSession(sessionId);
        } else if (this.localMode || this.existReplicated(sessionId)) {
            // empty if block
        }
    }

    public NetworkReqListener removeSessionListener(String sessionId) {
        if (this.localDataSource.exists(sessionId)) {
            return this.localDataSource.removeSessionListener(sessionId);
        }
        if (!this.localMode && this.existReplicated(sessionId)) {
            this.makeLocal(sessionId);
            return this.localDataSource.removeSessionListener(sessionId);
        }
        return null;
    }

    public void setSessionListener(String sessionId, NetworkReqListener data) {
        if (this.localDataSource.exists(sessionId)) {
            this.localDataSource.setSessionListener(sessionId, data);
        } else if (!this.localMode && this.existReplicated(sessionId)) {
            this.makeLocal(sessionId);
            this.localDataSource.setSessionListener(sessionId, data);
        }
    }

    public void start() {
        this.mobicentsCluster.getMobicentsCache().startCache();
        this.localMode = this.mobicentsCluster.getMobicentsCache().isLocalMode();
    }

    public void stop() {
        this.mobicentsCluster.getMobicentsCache().stopCache();
    }

    public boolean isClustered() {
        return !this.localMode;
    }

    public IAppSessionDataFactory<? extends IAppSessionData> getDataFactory(Class<? extends IAppSessionData> x) {
        return this.appSessionDataFactories.get(x);
    }

    public MobicentsCluster getMobicentsCluster() {
        return this.mobicentsCluster;
    }

    public void dataRemoved(Fqn sessionFqn) {
        String sessionId = (String)sessionFqn.getLastElement();
        this.localDataSource.removeSession(sessionId);
    }

    public Fqn getBaseFqn() {
        return SESSIONS_FQN;
    }

    private boolean existReplicated(String sessionId) {
        return !this.localMode && this.mobicentsCluster.getMobicentsCache().getJBossCache().getNode(Fqn.fromRelativeElements((Fqn)SESSIONS_FQN, (Object[])new String[]{sessionId})) != null;
    }

    private void makeLocal(String sessionId) {
        try {
            Class<? extends AppSession> appSessionInterfaceClass = AppSessionDataReplicatedImpl.getAppSessionIface(this.mobicentsCluster.getMobicentsCache(), sessionId);
            IAppSessionFactory fct = ((ISessionFactory)this.container.getSessionFactory()).getAppSessionFactory(appSessionInterfaceClass);
            if (fct == null) {
                logger.warn("Session with id:{}, is in replicated data source, but no Application Session Factory for:{}.", (Object)sessionId, appSessionInterfaceClass);
                return;
            }
            AppSession session = fct.getSession(sessionId, appSessionInterfaceClass);
            this.localDataSource.addSession((BaseSession)session);
            this.localDataSource.setSessionListener(sessionId, (NetworkReqListener)session);
            return;
        }
        catch (IllegalDiameterStateException e) {
            if (logger.isErrorEnabled()) {
                logger.error("Failed to obtain factory from stack...");
            }
            return;
        }
    }

    public IContainer getContainer() {
        return this.container;
    }
}

