/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.impl.ha.client.rf;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.jboss.cache.Fqn;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.Request;
import org.jdiameter.api.rf.ClientRfSession;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.parser.IMessageParser;
import org.jdiameter.client.api.parser.ParseException;
import org.jdiameter.client.impl.app.rf.IClientRfSessionData;
import org.jdiameter.common.api.app.rf.ClientRfSessionState;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.diameter.impl.ha.common.AppSessionDataReplicatedImpl;
import org.mobicents.diameter.impl.ha.data.ReplicatedSessionDatasource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientRfSessionDataReplicatedImpl
extends AppSessionDataReplicatedImpl
implements IClientRfSessionData {
    private static final Logger logger = LoggerFactory.getLogger(ClientRfSessionDataReplicatedImpl.class);
    private static final String STATE = "STATE";
    private static final String BUFFER = "BUFFER";
    private static final String TS_TIMERID = "TS_TIMERID";
    private static final String DESTINATION_HOST = "DESTINATION_HOST";
    private static final String DESTINATION_REALM = "DESTINATION_REALM";
    private IMessageParser messageParser;

    public ClientRfSessionDataReplicatedImpl(Fqn<?> nodeFqn, MobicentsCluster mobicentsCluster, IContainer container) {
        super(nodeFqn, mobicentsCluster);
        if (super.create()) {
            ClientRfSessionDataReplicatedImpl.setAppSessionIface(this, ClientRfSession.class);
            this.setClientRfSessionState(ClientRfSessionState.IDLE);
        }
        this.messageParser = (IMessageParser)container.getAssemblerFacility().getComponentInstance(IMessageParser.class);
    }

    public ClientRfSessionDataReplicatedImpl(String sessionId, MobicentsCluster mobicentsCluster, IContainer container) {
        this(Fqn.fromRelativeElements((Fqn)ReplicatedSessionDatasource.SESSIONS_FQN, (Object[])new String[]{sessionId}), mobicentsCluster, container);
    }

    public ClientRfSessionState getClientRfSessionState() {
        if (this.exists()) {
            return (ClientRfSessionState)this.getNode().get((Object)STATE);
        }
        throw new IllegalStateException();
    }

    public void setClientRfSessionState(ClientRfSessionState state) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)STATE, (Object)state);
    }

    public Request getBuffer() {
        byte[] data = (byte[])this.getNode().get((Object)BUFFER);
        if (data != null) {
            try {
                return this.messageParser.createMessage(ByteBuffer.wrap(data));
            }
            catch (AvpDataException e) {
                logger.error("Unable to recreate message from buffer.");
                return null;
            }
        }
        return null;
    }

    public void setBuffer(Request buffer) {
        if (buffer != null) {
            try {
                byte[] data = this.messageParser.encodeMessage((IMessage)buffer).array();
                this.getNode().put((Object)BUFFER, (Object)data);
            }
            catch (ParseException e) {
                logger.error("Unable to encode message to buffer.");
            }
        } else {
            this.getNode().remove((Object)BUFFER);
        }
    }

    public Serializable getTsTimerId() {
        if (this.exists()) {
            return (Serializable)this.getNode().get((Object)TS_TIMERID);
        }
        throw new IllegalStateException();
    }

    public void setTsTimerId(Serializable tid) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)TS_TIMERID, (Object)tid);
    }

    public String getDestinationHost() {
        if (this.exists()) {
            return (String)this.getNode().get((Object)DESTINATION_HOST);
        }
        throw new IllegalStateException();
    }

    public void setDestinationHost(String destinationHost) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)DESTINATION_HOST, (Object)destinationHost);
    }

    public String getDestinationRealm() {
        if (this.exists()) {
            return (String)this.getNode().get((Object)DESTINATION_REALM);
        }
        throw new IllegalStateException();
    }

    public void setDestinationRealm(String destinationRealm) {
        if (!this.exists()) {
            throw new IllegalStateException();
        }
        this.getNode().put((Object)DESTINATION_REALM, (Object)destinationRealm);
    }
}

