/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.api;

import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdiameter.api.GetPropertyAction;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Stack;
import org.jdiameter.api.StackInfo;

public final class StackManager {
    private static final Object logSync = new Object();
    private static List<StackInfo> stacks = new CopyOnWriteArrayList<StackInfo>();
    private static PrintWriter logWriter = null;
    private static boolean initialized = false;

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        StackManager.loadInitialStacks();
        StackManager.println("Diameter StackManager initialized");
    }

    private StackManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintWriter getLogWriter() {
        Object object = logSync;
        synchronized (object) {
            return logWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogWriter(PrintWriter out) {
        Object object = logSync;
        synchronized (object) {
            logWriter = out;
        }
    }

    public static synchronized Stack getStack(String className) throws InternalException {
        StackManager.println("StackManager.getStack(\"" + className + "\")");
        if (!initialized) {
            StackManager.initialize();
        }
        ClassLoader callerCL = ClassLoader.getSystemClassLoader();
        for (StackInfo di : stacks) {
            if (StackManager.getCallerClass(callerCL, di.stackClassName) != di.stackClass) {
                StackManager.println("    skipping: " + di);
                continue;
            }
            StackManager.println("    trying " + di);
            if (!di.stackClassName.equals(className)) continue;
            StackManager.println("geStack returning " + di);
            return di.stack;
        }
        StackManager.println("getStack: no suitable stack");
        throw new InternalException("No suitable stack");
    }

    public static synchronized void registerStack(Stack stack) throws InternalException {
        if (!initialized) {
            StackManager.initialize();
        }
        StackInfo stackInfo = new StackInfo();
        stackInfo.stack = stack;
        stackInfo.stackClass = stack.getClass();
        stackInfo.stackClassName = stackInfo.stackClass.getName();
        stacks.add(stackInfo);
        StackManager.println("registerStack: " + stackInfo);
    }

    public static synchronized void deregisterStack(Stack stack) throws InternalException {
        int i;
        ClassLoader callerCL = ClassLoader.getSystemClassLoader();
        StackManager.println("StackManager.deregisterStack: " + stack);
        StackInfo stackInfo = null;
        for (i = 0; i < stacks.size(); ++i) {
            stackInfo = stacks.get(i);
            if (stackInfo.stack == stack) break;
        }
        if (i >= stacks.size()) {
            StackManager.println("    couldn't find stack to unload");
            return;
        }
        if (stackInfo == null || StackManager.getCallerClass(callerCL, stackInfo.stackClassName) != stackInfo.stackClass) {
            throw new SecurityException();
        }
        stacks.remove(i);
    }

    public static synchronized Enumeration<Stack> getStacks() {
        CopyOnWriteArrayList<Stack> result = new CopyOnWriteArrayList<Stack>();
        if (!initialized) {
            StackManager.initialize();
        }
        ClassLoader callerCL = ClassLoader.getSystemClassLoader();
        for (StackInfo di : stacks) {
            if (StackManager.getCallerClass(callerCL, di.stackClassName) != di.stackClass) {
                StackManager.println("    skipping: " + di);
                continue;
            }
            result.add(di.stack);
        }
        return Collections.enumeration(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String message) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(message);
                logWriter.flush();
            }
        }
    }

    private static Class getCallerClass(ClassLoader callerClassLoader, String stackClassName) {
        Class<?> callerC;
        try {
            callerC = Class.forName(stackClassName, true, callerClassLoader);
        }
        catch (Exception ex) {
            callerC = null;
        }
        return callerC;
    }

    private static void loadInitialStacks() {
        String stacks;
        try {
            stacks = AccessController.doPrivileged(new GetPropertyAction("diameter.stacks"));
        }
        catch (Exception ex) {
            stacks = null;
        }
        StackManager.println("StackManager.initialize: diameter.stacks = " + stacks);
        if (stacks == null) {
            return;
        }
        while (stacks.length() != 0) {
            String stack;
            int x = stacks.indexOf(58);
            if (x < 0) {
                stack = stacks;
                stacks = "";
            } else {
                stack = stacks.substring(0, x);
                stacks = stacks.substring(x + 1);
            }
            if (stack.length() == 0) continue;
            try {
                StackManager.println("StackManager.Initialize: loading " + stack);
                Class.forName(stack, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception ex) {
                StackManager.println("StackManager.Initialize: load failed: " + ex);
            }
        }
    }
}

