/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.mobicents.cache.MobicentsCache;

public class CacheData {
    private static final Logger logger = Logger.getLogger(CacheData.class);
    private Node node;
    private final Fqn nodeFqn;
    private boolean isRemoved;
    private final MobicentsCache mobicentsCache;
    private static final boolean doTraceLogs = logger.isTraceEnabled();

    public CacheData(Fqn nodeFqn, MobicentsCache mobicentsCache) {
        this.nodeFqn = nodeFqn;
        this.mobicentsCache = mobicentsCache;
        this.node = mobicentsCache.getJBossCache().getRoot().getChild(nodeFqn);
        if (doTraceLogs) {
            logger.trace((Object)("cache node " + nodeFqn + " retrieved, result = " + this.node));
        }
    }

    public boolean exists() {
        return this.node != null;
    }

    public boolean create() {
        if (!this.exists()) {
            this.node = this.mobicentsCache.getJBossCache().getRoot().addChild(this.nodeFqn);
            if (doTraceLogs) {
                logger.trace((Object)("created cache node " + this.nodeFqn));
            }
            return true;
        }
        return false;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean remove() {
        if (this.exists() && !this.isRemoved()) {
            this.isRemoved = true;
            this.node.getParent().removeChild(this.nodeFqn.getLastElement());
            if (doTraceLogs) {
                logger.trace((Object)("removed cache node " + this.nodeFqn));
            }
            return true;
        }
        return false;
    }

    protected Node getNode() {
        if (this.isRemoved()) {
            throw new IllegalStateException();
        }
        return this.node;
    }

    public MobicentsCache getMobicentsCache() {
        return this.mobicentsCache;
    }

    public Fqn getNodeFqn() {
        return this.nodeFqn;
    }
}

