/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow;

import java.io.IOException;
import java.util.Optional;
import org.mlflow.Flavor;
import org.mlflow.models.Model;
import org.mlflow.sagemaker.Predictor;
import org.mlflow.sagemaker.PredictorLoadingException;

public abstract class LoaderModule<T extends Flavor> {
    public Predictor load(Model model) {
        Optional<T> flavor = model.getFlavor(this.getFlavorName(), this.getFlavorClass());
        if (!flavor.isPresent()) {
            throw new PredictorLoadingException(String.format("Attempted to load the %s flavor of the model, but the model does not have this flavor.", this.getFlavorName()));
        }
        Optional<String> rootPath = model.getRootPath();
        if (!rootPath.isPresent()) {
            throw new PredictorLoadingException("An internal error occurred while loading the model: the model's root path could not be found. Please ensure that this model was created using `Model.fromRootPath()` or `Model.fromConfigPath()`");
        }
        return this.createPredictor(rootPath.get(), (Flavor)flavor.get());
    }

    public Predictor load(String modelRootPath) throws PredictorLoadingException {
        try {
            Optional<Model> model = Optional.of(Model.fromRootPath(modelRootPath));
            return this.load(model.get());
        }
        catch (IOException e) {
            throw new PredictorLoadingException("Failed to load the model configuration at the specified path. Please ensure that this is the path to the root directory of a valid MLFlow model");
        }
    }

    protected abstract Predictor createPredictor(String var1, T var2) throws PredictorLoadingException;

    protected abstract Class<T> getFlavorClass();

    protected abstract String getFlavorName();
}

