/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.sagemaker;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mlflow.sagemaker.InvalidSchemaException;
import org.mlflow.utils.SerializationUtils;

class LeapFrameSchema {
    private final Map<String, Object> rawSchema;
    private final List<String> fieldNames;

    private LeapFrameSchema(Map<String, Object> rawSchema) {
        this.rawSchema = rawSchema;
        if (!rawSchema.containsKey("fields")) {
            throw new InvalidSchemaException("Leap frame schema must contain a top-level `fields` key!");
        }
        ObjectMapper mapper = new ObjectMapper();
        List fields = (List)mapper.convertValue(rawSchema.get("fields"), (TypeReference)new TypeReference<List<SchemaField>>(){});
        this.fieldNames = new ArrayList<String>();
        for (SchemaField field : fields) {
            this.fieldNames.add(field.name);
        }
    }

    static LeapFrameSchema fromPath(String filePath) throws IOException {
        File schemaFile = new File(filePath);
        try {
            return new LeapFrameSchema(SerializationUtils.parseJsonFromFile(filePath, Map.class));
        }
        catch (IOException e) {
            throw new InvalidSchemaException("The specified schema could not be parsed as JSON.");
        }
    }

    List<String> getFieldNames() {
        return this.fieldNames;
    }

    Map<String, Object> getRawSchema() {
        return this.rawSchema;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SchemaField {
        @JsonProperty(value="name")
        String name;

        private SchemaField() {
        }
    }
}

