/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.entity;

import java.io.IOException;
import java.io.OutputStream;
import org.mlflow_project.apachehttp.HttpEntity;
import org.mlflow_project.apachehttp.HttpException;
import org.mlflow_project.apachehttp.HttpMessage;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.entity.ContentLengthStrategy;
import org.mlflow_project.apachehttp.impl.io.ChunkedOutputStream;
import org.mlflow_project.apachehttp.impl.io.ContentLengthOutputStream;
import org.mlflow_project.apachehttp.impl.io.IdentityOutputStream;
import org.mlflow_project.apachehttp.io.SessionOutputBuffer;
import org.mlflow_project.apachehttp.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntitySerializer {
    private final ContentLengthStrategy lenStrategy;

    public EntitySerializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected OutputStream doSerialize(SessionOutputBuffer outbuffer, HttpMessage message) throws HttpException, IOException {
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            return new ChunkedOutputStream(outbuffer);
        }
        if (len == -1L) {
            return new IdentityOutputStream(outbuffer);
        }
        return new ContentLengthOutputStream(outbuffer, len);
    }

    public void serialize(SessionOutputBuffer outbuffer, HttpMessage message, HttpEntity entity) throws HttpException, IOException {
        Args.notNull(outbuffer, "Session output buffer");
        Args.notNull(message, "HTTP message");
        Args.notNull(entity, "HTTP entity");
        OutputStream outstream = this.doSerialize(outbuffer, message);
        entity.writeTo(outstream);
        outstream.close();
    }
}

