/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.cookie;

import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.conn.util.PublicSuffixMatcher;
import org.mlflow_project.apachehttp.cookie.Cookie;
import org.mlflow_project.apachehttp.cookie.CookieOrigin;
import org.mlflow_project.apachehttp.cookie.CookieSpec;
import org.mlflow_project.apachehttp.cookie.CookieSpecProvider;
import org.mlflow_project.apachehttp.cookie.MalformedCookieException;
import org.mlflow_project.apachehttp.impl.cookie.BasicDomainHandler;
import org.mlflow_project.apachehttp.impl.cookie.BasicExpiresHandler;
import org.mlflow_project.apachehttp.impl.cookie.BasicMaxAgeHandler;
import org.mlflow_project.apachehttp.impl.cookie.BasicPathHandler;
import org.mlflow_project.apachehttp.impl.cookie.BasicSecureHandler;
import org.mlflow_project.apachehttp.impl.cookie.LaxExpiresHandler;
import org.mlflow_project.apachehttp.impl.cookie.LaxMaxAgeHandler;
import org.mlflow_project.apachehttp.impl.cookie.PublicSuffixDomainFilter;
import org.mlflow_project.apachehttp.impl.cookie.RFC6265LaxSpec;
import org.mlflow_project.apachehttp.impl.cookie.RFC6265StrictSpec;
import org.mlflow_project.apachehttp.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RFC6265CookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private volatile CookieSpec cookieSpec;

    public RFC6265CookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : CompatibilityLevel.RELAXED;
        this.publicSuffixMatcher = publicSuffixMatcher;
    }

    public RFC6265CookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.RELAXED, publicSuffixMatcher);
    }

    public RFC6265CookieSpecProvider() {
        this(CompatibilityLevel.RELAXED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            RFC6265CookieSpecProvider rFC6265CookieSpecProvider = this;
            synchronized (rFC6265CookieSpecProvider) {
                if (this.cookieSpec == null) {
                    switch (this.compatibilityLevel) {
                        case STRICT: {
                            this.cookieSpec = new RFC6265StrictSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        case IE_MEDIUM_SECURITY: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(){

                                @Override
                                public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                                }
                            }, PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicExpiresHandler(RFC6265StrictSpec.DATE_PATTERNS));
                            break;
                        }
                        default: {
                            this.cookieSpec = new RFC6265LaxSpec(new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher), new LaxMaxAgeHandler(), new BasicSecureHandler(), new LaxExpiresHandler());
                        }
                    }
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        STRICT,
        RELAXED,
        IE_MEDIUM_SECURITY;

    }
}

