/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking.utils;

import java.util.HashMap;
import java.util.Map;
import org.mlflow_project.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksContext {
    public static final String CONFIG_PROVIDER_CLASS_NAME = "com.databricks.config.DatabricksClientSettingsProvider";
    private static final Logger logger = LoggerFactory.getLogger(DatabricksContext.class);
    private final Map<String, String> configProvider;

    private DatabricksContext(Map<String, String> configProvider) {
        this.configProvider = configProvider;
    }

    public static DatabricksContext createIfAvailable() {
        return DatabricksContext.createIfAvailable(CONFIG_PROVIDER_CLASS_NAME);
    }

    @VisibleForTesting
    static DatabricksContext createIfAvailable(String className) {
        Map<String, String> configProvider = DatabricksContext.getConfigProviderIfAvailable(className);
        if (configProvider == null) {
            return null;
        }
        return new DatabricksContext(configProvider);
    }

    public Map<String, String> getTags() {
        if (this.isInDatabricksNotebook()) {
            return this.getTagsForDatabricksNotebook();
        }
        if (this.isInDatabricksJob()) {
            return this.getTagsForDatabricksJob();
        }
        return new HashMap<String, String>();
    }

    public boolean isInDatabricksNotebook() {
        return this.configProvider.get("notebookId") != null;
    }

    private Map<String, String> getTagsForDatabricksNotebook() {
        String webappUrl;
        String notebookPath;
        HashMap<String, String> tagsForNotebook = new HashMap<String, String>();
        String notebookId = this.getNotebookId();
        if (notebookId != null) {
            tagsForNotebook.put("mlflow.databricks.notebookID", notebookId);
        }
        if ((notebookPath = this.configProvider.get("notebookPath")) != null) {
            tagsForNotebook.put("mlflow.source.name", notebookPath);
            tagsForNotebook.put("mlflow.databricks.notebookPath", notebookPath);
            tagsForNotebook.put("mlflow.source.type", "NOTEBOOK");
        }
        if ((webappUrl = this.configProvider.get("host")) != null) {
            tagsForNotebook.put("mlflow.databricks.webappURL", webappUrl);
        }
        return tagsForNotebook;
    }

    public String getNotebookId() {
        if (!this.isInDatabricksNotebook()) {
            throw new IllegalArgumentException("getNotebookId() should not be called when isInDatabricksNotebook() is false");
        }
        return this.configProvider.get("notebookId");
    }

    public String getNotebookPath() {
        if (!this.isInDatabricksNotebook()) {
            throw new IllegalArgumentException("getNotebookPath() should not be called when isInDatabricksNotebook() is false");
        }
        return this.configProvider.get("notebookPath");
    }

    private boolean isInDatabricksJob() {
        return this.configProvider.get("jobId") != null;
    }

    private Map<String, String> getTagsForDatabricksJob() {
        HashMap<String, String> tagsForJob = new HashMap<String, String>();
        String jobId = this.configProvider.get("jobId");
        String jobRunId = this.configProvider.get("jobRunId");
        String jobType = this.configProvider.get("jobType");
        String webappUrl = this.configProvider.get("host");
        if (jobId != null && jobRunId != null) {
            tagsForJob.put("mlflow.databricks.jobID", jobId);
            tagsForJob.put("mlflow.databricks.jobRunID", jobRunId);
            tagsForJob.put("mlflow.source.type", "JOB");
            tagsForJob.put("mlflow.source.name", String.format("jobs/%s/run/%s", jobId, jobRunId));
        }
        if (jobType != null) {
            tagsForJob.put("mlflow.databricks.jobType", jobType);
        }
        if (webappUrl != null) {
            tagsForJob.put("mlflow.databricks.webappURL", webappUrl);
        }
        return tagsForJob;
    }

    public static Map<String, String> getConfigProviderIfAvailable(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return (Map)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn("Found but failed to invoke dynamic config provider", (Throwable)e);
            return null;
        }
    }
}

