/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.pool;

import java.util.concurrent.atomic.AtomicLong;
import org.mlflow_project.apachehttp.HttpClientConnection;
import org.mlflow_project.apachehttp.HttpHost;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.config.ConnectionConfig;
import org.mlflow_project.apachehttp.config.SocketConfig;
import org.mlflow_project.apachehttp.impl.pool.BasicConnFactory;
import org.mlflow_project.apachehttp.impl.pool.BasicPoolEntry;
import org.mlflow_project.apachehttp.params.HttpParams;
import org.mlflow_project.apachehttp.pool.AbstractConnPool;
import org.mlflow_project.apachehttp.pool.ConnFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

