/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.io;

import org.mlflow_project.apachehttp.HttpRequest;
import org.mlflow_project.apachehttp.HttpRequestFactory;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.config.MessageConstraints;
import org.mlflow_project.apachehttp.impl.DefaultHttpRequestFactory;
import org.mlflow_project.apachehttp.impl.io.DefaultHttpRequestParser;
import org.mlflow_project.apachehttp.io.HttpMessageParser;
import org.mlflow_project.apachehttp.io.HttpMessageParserFactory;
import org.mlflow_project.apachehttp.io.SessionInputBuffer;
import org.mlflow_project.apachehttp.message.BasicLineParser;
import org.mlflow_project.apachehttp.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

