/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.cookie;

import java.util.Date;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.cookie.CommonCookieAttributeHandler;
import org.mlflow_project.apachehttp.cookie.MalformedCookieException;
import org.mlflow_project.apachehttp.cookie.SetCookie;
import org.mlflow_project.apachehttp.impl.cookie.AbstractCookieAttributeHandler;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "max-age";
    }
}

