/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking.samples;

import java.util.List;
import java.util.Optional;
import org.mlflow.api.proto.Service;
import org.mlflow.tracking.MlflowClient;

public class QuickStartDriver {
    public static void main(String[] args) throws Exception {
        new QuickStartDriver().process(args);
    }

    void process(String[] args) throws Exception {
        MlflowClient client = args.length < 1 ? new MlflowClient() : new MlflowClient(args[0]);
        System.out.println("====== createExperiment");
        String expName = "Exp_" + System.currentTimeMillis();
        String expId = client.createExperiment(expName);
        System.out.println("createExperiment: expId=" + expId);
        System.out.println("====== getExperiment");
        Service.GetExperiment.Response exp = client.getExperiment(expId);
        System.out.println("getExperiment: " + exp);
        System.out.println("====== listExperiments");
        List<Service.Experiment> exps = client.listExperiments();
        System.out.println("#experiments: " + exps.size());
        exps.forEach(e -> System.out.println("  Exp: " + e));
        this.createRun(client, expId);
        System.out.println("====== getExperiment again");
        Service.GetExperiment.Response exp2 = client.getExperiment(expId);
        System.out.println("getExperiment: " + exp2);
        System.out.println("====== getExperiment by name");
        Optional<Service.Experiment> exp3 = client.getExperimentByName(expName);
        System.out.println("getExperimentByName: " + exp3);
    }

    void createRun(MlflowClient client, String expId) {
        System.out.println("====== createRun");
        String sourceFile = "MyFile.java";
        Service.RunInfo runCreated = client.createRun(expId);
        System.out.println("CreateRun: " + runCreated);
        String runId = runCreated.getRunUuid();
        client.logParam(runId, "min_samples_leaf", "2");
        client.logParam(runId, "max_depth", "3");
        client.logMetric(runId, "auc", 2.12f);
        client.logMetric(runId, "accuracy_score", 3.12f);
        client.logMetric(runId, "zero_one_loss", 4.12f);
        client.setTerminated(runId, Service.RunStatus.FINISHED);
        Service.Run run = client.getRun(runId);
        System.out.println("GetRun: " + run);
    }
}

