/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.mlflow_project.apachehttp.HttpException;
import org.mlflow_project.apachehttp.HttpHost;
import org.mlflow_project.apachehttp.HttpRequest;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.client.ClientProtocolException;
import org.mlflow_project.apachehttp.client.config.RequestConfig;
import org.mlflow_project.apachehttp.client.methods.CloseableHttpResponse;
import org.mlflow_project.apachehttp.client.methods.Configurable;
import org.mlflow_project.apachehttp.client.methods.HttpExecutionAware;
import org.mlflow_project.apachehttp.client.methods.HttpRequestWrapper;
import org.mlflow_project.apachehttp.client.protocol.HttpClientContext;
import org.mlflow_project.apachehttp.conn.ClientConnectionManager;
import org.mlflow_project.apachehttp.conn.ClientConnectionRequest;
import org.mlflow_project.apachehttp.conn.HttpClientConnectionManager;
import org.mlflow_project.apachehttp.conn.ManagedClientConnection;
import org.mlflow_project.apachehttp.conn.routing.HttpRoute;
import org.mlflow_project.apachehttp.conn.scheme.SchemeRegistry;
import org.mlflow_project.apachehttp.impl.DefaultConnectionReuseStrategy;
import org.mlflow_project.apachehttp.impl.client.CloseableHttpClient;
import org.mlflow_project.apachehttp.impl.client.DefaultConnectionKeepAliveStrategy;
import org.mlflow_project.apachehttp.impl.execchain.MinimalClientExec;
import org.mlflow_project.apachehttp.params.BasicHttpParams;
import org.mlflow_project.apachehttp.params.HttpParams;
import org.mlflow_project.apachehttp.protocol.BasicHttpContext;
import org.mlflow_project.apachehttp.protocol.HttpContext;
import org.mlflow_project.apachehttp.protocol.HttpRequestExecutor;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

