/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import org.mlflow.tracking.MlflowClientException;
import org.mlflow.tracking.MlflowClientVersion;
import org.mlflow.tracking.MlflowHttpException;
import org.mlflow.tracking.creds.MlflowHostCreds;
import org.mlflow.tracking.creds.MlflowHostCredsProvider;
import org.mlflow_project.apachehttp.HttpResponse;
import org.mlflow_project.apachehttp.client.HttpClient;
import org.mlflow_project.apachehttp.client.methods.HttpEntityEnclosingRequestBase;
import org.mlflow_project.apachehttp.client.methods.HttpGet;
import org.mlflow_project.apachehttp.client.methods.HttpPatch;
import org.mlflow_project.apachehttp.client.methods.HttpPost;
import org.mlflow_project.apachehttp.client.methods.HttpRequestBase;
import org.mlflow_project.apachehttp.conn.ssl.NoopHostnameVerifier;
import org.mlflow_project.apachehttp.conn.ssl.SSLConnectionSocketFactory;
import org.mlflow_project.apachehttp.conn.ssl.TrustSelfSignedStrategy;
import org.mlflow_project.apachehttp.entity.StringEntity;
import org.mlflow_project.apachehttp.impl.client.HttpClientBuilder;
import org.mlflow_project.apachehttp.ssl.SSLContextBuilder;
import org.mlflow_project.apachehttp.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MlflowHttpCaller {
    private static final Logger logger = LoggerFactory.getLogger(MlflowHttpCaller.class);
    private static final String BASE_API_PATH = "api/2.0/preview/mlflow";
    protected HttpClient httpClient;
    private final MlflowHostCredsProvider hostCredsProvider;
    private final int maxRateLimitIntervalMillis;
    private final int rateLimitRetrySleepInitMillis;

    MlflowHttpCaller(MlflowHostCredsProvider hostCredsProvider) {
        this(hostCredsProvider, 60000);
    }

    MlflowHttpCaller(MlflowHostCredsProvider hostCredsProvider, int maxRateLimitIntervalSeconds) {
        this(hostCredsProvider, maxRateLimitIntervalSeconds, 1000);
    }

    MlflowHttpCaller(MlflowHostCredsProvider hostCredsProvider, int maxRateLimitIntervalSeconds, int rateLimitRetrySleepInitMs) {
        this.hostCredsProvider = hostCredsProvider;
        this.maxRateLimitIntervalMillis = maxRateLimitIntervalSeconds;
        this.rateLimitRetrySleepInitMillis = rateLimitRetrySleepInitMs;
    }

    MlflowHttpCaller(MlflowHostCredsProvider hostCredsProvider, int maxRateLimitIntervalSeconds, int rateLimitRetrySleepInitMs, HttpClient client) {
        this(hostCredsProvider, maxRateLimitIntervalSeconds, rateLimitRetrySleepInitMs);
        this.httpClient = client;
    }

    HttpResponse executeRequest(HttpRequestBase request) throws IOException {
        int timeLeft = this.maxRateLimitIntervalMillis;
        int sleepFor = this.rateLimitRetrySleepInitMillis;
        HttpResponse response = this.httpClient.execute(request);
        while (response.getStatusLine().getStatusCode() == 429 && timeLeft > 0) {
            logger.warn("Request returned with status code 429 (Rate limit exceeded). Retrying after " + sleepFor + " milliseconds. Will continue to retry 429s for up to " + timeLeft + " milliseconds.");
            try {
                Thread.sleep(sleepFor);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            sleepFor = Math.min(timeLeft -= sleepFor, 2 * sleepFor);
            response = this.httpClient.execute(request);
        }
        this.checkError(response);
        return response;
    }

    String get(String path) {
        logger.debug("Sending GET " + path);
        HttpGet request = new HttpGet();
        this.fillRequestSettings(request, path);
        try {
            HttpResponse response = this.executeRequest(request);
            String responseJosn = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            logger.debug("Response: " + responseJosn);
            return responseJosn;
        }
        catch (IOException e) {
            throw new MlflowClientException(e);
        }
    }

    byte[] getAsBytes(String path) {
        logger.debug("Sending GET " + path);
        HttpGet request = new HttpGet();
        this.fillRequestSettings(request, path);
        try {
            HttpResponse response = this.executeRequest(request);
            byte[] bytes = EntityUtils.toByteArray(response.getEntity());
            logger.debug("response: #bytes=" + bytes.length);
            return bytes;
        }
        catch (IOException e) {
            throw new MlflowClientException(e);
        }
    }

    String post(String path, String json) {
        logger.debug("Sending POST " + path + ": " + json);
        HttpPost request = new HttpPost();
        return this.send(request, path, json);
    }

    String patch(String path, String json) {
        logger.debug("Sending PATCH " + path + ": " + json);
        HttpPatch request = new HttpPatch();
        return this.send(request, path, json);
    }

    private String send(HttpEntityEnclosingRequestBase request, String path, String json) {
        this.fillRequestSettings(request, path);
        request.setEntity(new StringEntity(json, StandardCharsets.UTF_8));
        request.setHeader("Content-Type", "application/json");
        try {
            HttpResponse response = this.executeRequest(request);
            String responseJson = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            logger.debug("Response: " + responseJson);
            return responseJson;
        }
        catch (IOException e) {
            throw new MlflowClientException(e);
        }
    }

    private void checkError(HttpResponse response) throws MlflowClientException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        if (this.isError(statusCode)) {
            String bodyMessage = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            if (statusCode >= 400 && statusCode <= 499) {
                throw new MlflowHttpException(statusCode, reasonPhrase, bodyMessage);
            }
            if (statusCode >= 500 && statusCode <= 599) {
                throw new MlflowHttpException(statusCode, reasonPhrase, bodyMessage);
            }
            throw new MlflowHttpException(statusCode, reasonPhrase, bodyMessage);
        }
    }

    private void fillRequestSettings(HttpRequestBase request, String path) {
        MlflowHostCreds hostCreds = this.hostCredsProvider.getHostCreds();
        this.createHttpClientIfNecessary(hostCreds.shouldIgnoreTlsVerification());
        String uri = hostCreds.getHost() + "/" + BASE_API_PATH + "/" + path;
        request.setURI(URI.create(uri));
        String username = hostCreds.getUsername();
        String password = hostCreds.getPassword();
        String token = hostCreds.getToken();
        if (username != null && password != null) {
            String authHeader = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
            request.addHeader("Authorization", "Basic " + authHeader);
        } else if (token != null) {
            request.addHeader("Authorization", "Bearer " + token);
        }
        String userAgent = "mlflow-java-client";
        String clientVersion = MlflowClientVersion.getClientVersion();
        if (!clientVersion.isEmpty()) {
            userAgent = userAgent + "/" + clientVersion;
        }
        request.addHeader("User-Agent", userAgent);
    }

    private boolean isError(int statusCode) {
        return statusCode < 200 || statusCode > 399;
    }

    private void createHttpClientIfNecessary(boolean noTlsVerify) {
        if (this.httpClient != null) {
            return;
        }
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (noTlsVerify) {
            try {
                SSLContextBuilder sslBuilder = new SSLContextBuilder().loadTrustMaterial(null, new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslBuilder.build(), (HostnameVerifier)new NoopHostnameVerifier());
                builder.setSSLSocketFactory(connectionFactory);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                logger.warn("Could not set noTlsVerify to true, verification will remain", (Throwable)e);
            }
        }
        this.httpClient = builder.build();
    }
}

