/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking.creds;

import java.util.Map;
import org.mlflow.tracking.creds.BasicMlflowHostCreds;
import org.mlflow.tracking.creds.MlflowHostCreds;
import org.mlflow.tracking.creds.MlflowHostCredsProvider;
import org.mlflow_project.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksDynamicHostCredsProvider
implements MlflowHostCredsProvider {
    private static final Logger logger = LoggerFactory.getLogger(DatabricksDynamicHostCredsProvider.class);
    private final Map<String, String> configProvider;

    private DatabricksDynamicHostCredsProvider(Map<String, String> configProvider) {
        this.configProvider = configProvider;
    }

    public static DatabricksDynamicHostCredsProvider createIfAvailable() {
        return DatabricksDynamicHostCredsProvider.createIfAvailable("com.databricks.config.DatabricksClientSettingsProvider");
    }

    @VisibleForTesting
    static DatabricksDynamicHostCredsProvider createIfAvailable(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return new DatabricksDynamicHostCredsProvider((Map)cls.newInstance());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn("Found but failed to invoke dynamic config provider", (Throwable)e);
            return null;
        }
    }

    @Override
    public MlflowHostCreds getHostCreds() {
        return new BasicMlflowHostCreds(this.configProvider.get("host"), this.configProvider.get("username"), this.configProvider.get("password"), this.configProvider.get("token"), "true".equals(this.configProvider.get("shouldIgnoreTlsVerification")));
    }

    @Override
    public void refresh() {
    }
}

