/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking.creds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.mlflow.tracking.MlflowClientException;
import org.mlflow.tracking.creds.MlflowHostCreds;
import org.mlflow.tracking.creds.MlflowHostCredsProvider;

public class HostCredsProviderChain
implements MlflowHostCredsProvider {
    private static final Logger logger = Logger.getLogger(HostCredsProviderChain.class);
    private final List<MlflowHostCredsProvider> hostCredsProviders = new ArrayList<MlflowHostCredsProvider>();

    public HostCredsProviderChain(MlflowHostCredsProvider ... hostCredsProviders) {
        this.hostCredsProviders.addAll(Arrays.asList(hostCredsProviders));
    }

    @Override
    public MlflowHostCreds getHostCreds() {
        ArrayList<String> exceptionMessages = new ArrayList<String>();
        for (MlflowHostCredsProvider provider : this.hostCredsProviders) {
            try {
                MlflowHostCreds hostCreds = provider.getHostCreds();
                if (hostCreds == null || hostCreds.getHost() == null) continue;
                logger.debug((Object)("Loading credentials from " + provider.toString()));
                return hostCreds;
            }
            catch (Exception e) {
                String message = provider + ": " + e.getMessage();
                logger.debug((Object)("Unable to load credentials from " + message));
                exceptionMessages.add(message);
            }
        }
        throw new MlflowClientException("Unable to load MLflow Host/Credentials from any provider in the chain: " + exceptionMessages);
    }

    @Override
    public void refresh() {
        for (MlflowHostCredsProvider provider : this.hostCredsProviders) {
            provider.refresh();
        }
    }
}

