/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.token;

import java.util.Set;
import org.mitre.oauth2.service.SystemScopeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.exceptions.InvalidScopeException;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenRequest;

public class ScopeServiceAwareOAuth2RequestValidator
implements OAuth2RequestValidator {
    @Autowired
    private SystemScopeService scopeService;

    private void validateScope(Set<String> requestedScopes, Set<String> clientScopes) throws InvalidScopeException {
        if (!(requestedScopes == null || requestedScopes.isEmpty() || clientScopes == null || clientScopes.isEmpty() || this.scopeService.scopesMatch(clientScopes, requestedScopes))) {
            throw new InvalidScopeException("Invalid scope; requested:" + requestedScopes, clientScopes);
        }
    }

    public void validateScope(AuthorizationRequest authorizationRequest, ClientDetails client) throws InvalidScopeException {
        this.validateScope(authorizationRequest.getScope(), client.getScope());
    }

    public void validateScope(TokenRequest tokenRequest, ClientDetails client) throws InvalidScopeException {
        this.validateScope(tokenRequest.getScope(), client.getScope());
    }
}

