/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.service.impl;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mitre.data.AbstractPageOperationTemplate;
import org.mitre.oauth2.model.AuthenticationHolderEntity;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.DeviceCode;
import org.mitre.oauth2.repository.impl.DeviceCodeRepository;
import org.mitre.oauth2.service.DeviceCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.common.util.RandomValueStringGenerator;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDeviceCodeService")
public class DefaultDeviceCodeService
implements DeviceCodeService {
    @Autowired
    private DeviceCodeRepository repository;
    private RandomValueStringGenerator randomGenerator = new RandomValueStringGenerator();

    public DeviceCode createNewDeviceCode(Set<String> requestedScopes, ClientDetailsEntity client, Map<String, String> parameters) {
        String deviceCode = UUID.randomUUID().toString();
        String userCode = this.randomGenerator.generate().toUpperCase();
        DeviceCode dc = new DeviceCode(deviceCode, userCode, requestedScopes, client.getClientId(), parameters);
        if (client.getDeviceCodeValiditySeconds() != null) {
            dc.setExpiration(new Date(System.currentTimeMillis() + (long)client.getDeviceCodeValiditySeconds().intValue() * 1000L));
        }
        dc.setApproved(false);
        return this.repository.save(dc);
    }

    public DeviceCode lookUpByUserCode(String userCode) {
        return this.repository.getByUserCode(userCode.toUpperCase());
    }

    public DeviceCode approveDeviceCode(DeviceCode dc, OAuth2Authentication auth) {
        DeviceCode found = this.repository.getById(dc.getId());
        found.setApproved(true);
        AuthenticationHolderEntity authHolder = new AuthenticationHolderEntity();
        authHolder.setAuthentication(auth);
        found.setAuthenticationHolder(authHolder);
        return this.repository.save(found);
    }

    public DeviceCode findDeviceCode(String deviceCode, ClientDetails client) {
        DeviceCode found = this.repository.getByDeviceCode(deviceCode);
        if (found != null) {
            if (found.getClientId().equals(client.getClientId())) {
                return found;
            }
            return null;
        }
        return null;
    }

    @Transactional(value="defaultTransactionManager")
    public void clearExpiredDeviceCodes() {
        new AbstractPageOperationTemplate<DeviceCode>("clearExpiredDeviceCodes"){

            public Collection<DeviceCode> fetchPage() {
                return DefaultDeviceCodeService.this.repository.getExpiredCodes();
            }

            protected void doOperation(DeviceCode item) {
                DefaultDeviceCodeService.this.repository.remove(item);
            }
        }.execute();
    }

    public void clearDeviceCode(String deviceCode, ClientDetails client) {
        DeviceCode found = this.findDeviceCode(deviceCode, client);
        if (found != null) {
            this.repository.remove(found);
        }
    }
}

