/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.FilterSettings;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.Visitor;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.HtmlReportGenerator;
import org.milyn.javabean.dynamic.BeanMetadata;
import org.milyn.javabean.dynamic.BeanRegistrationException;
import org.milyn.javabean.dynamic.Descriptor;
import org.milyn.javabean.dynamic.Model;
import org.milyn.javabean.dynamic.serialize.BeanWriter;
import org.milyn.javabean.dynamic.visitor.NamespaceReaper;
import org.milyn.javabean.dynamic.visitor.UnknownElementDataReaper;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.payload.JavaResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder {
    private static Log logger = LogFactory.getLog(ModelBuilder.class);
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private Descriptor descriptor;
    private boolean validate = true;
    private String reportPath;

    public ModelBuilder(Descriptor descriptor, boolean validate) throws SAXException, IOException {
        AssertArgument.isNotNull((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        this.validate = validate;
        this.configure();
    }

    public ModelBuilder(String descriptorPath, boolean validate) throws SAXException, IOException {
        AssertArgument.isNotNullAndNotEmpty((String)descriptorPath, (String)"descriptorPath");
        this.descriptor = new Descriptor(descriptorPath);
        this.validate = validate;
        this.configure();
    }

    public boolean isValidating() {
        return this.validate;
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public <T> T readObject(InputStream message, Class<T> returnType) throws SAXException, IOException {
        return this.readObject(new InputStreamReader(message), returnType);
    }

    public <T> T readObject(Reader message, Class<T> returnType) throws SAXException, IOException {
        Model<JavaResult> model = this.readModel(message, JavaResult.class);
        return (T)model.getModelRoot().getBean(returnType);
    }

    public <T> Model<T> readModel(InputStream message, Class<T> modelRoot) throws SAXException, IOException {
        return this.readModel(new InputStreamReader(message), modelRoot);
    }

    public <T> Model<T> readModel(Reader message, Class<T> modelRoot) throws SAXException, IOException {
        AssertArgument.isNotNull((Object)message, (String)"message");
        AssertArgument.isNotNull(modelRoot, (String)"modelRoot");
        JavaResult result = new JavaResult();
        ExecutionContext executionContext = this.descriptor.getSmooks().createExecutionContext();
        Map<Class<?>, Map<String, BeanWriter>> beanWriters = this.descriptor.getBeanWriters();
        BeanTracker beanTracker = new BeanTracker(beanWriters);
        if (this.reportPath != null) {
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator(this.reportPath));
        }
        executionContext.getBeanContext().addObserver(beanTracker);
        if (this.validate && this.descriptor.getSchema() != null) {
            Document messageDoc = this.toDocument(message);
            this.descriptor.getSchema().newValidator().validate(new DOMSource(messageDoc));
            this.descriptor.getSmooks().filterSource(executionContext, (Source)new DOMSource(messageDoc), new Result[]{result});
        } else {
            this.descriptor.getSmooks().filterSource(executionContext, (Source)new StreamSource(message), new Result[]{result});
        }
        Model<T> model = modelRoot == JavaResult.class ? new Model<T>(modelRoot.cast(result), beanTracker.beans, beanWriters, NamespaceReaper.getNamespacePrefixMappings(executionContext)) : new Model<T>(modelRoot.cast(result.getBean(modelRoot)), beanTracker.beans, beanWriters, NamespaceReaper.getNamespacePrefixMappings(executionContext));
        return model;
    }

    private Document toDocument(Reader message) {
        DocumentBuilder docBuilder;
        try {
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SmooksException("Unable to parse message and dynamically bind into object model.  DOM Parser confguration exception.", (Throwable)e);
        }
        try {
            Document e = docBuilder.parse(new InputSource(message));
            return e;
        }
        catch (SAXException e) {
            throw new SmooksException("Unable to parse message and dynamically bind into object model.  Message format exception.", (Throwable)e);
        }
        catch (IOException e) {
            throw new SmooksException("Unable to parse message and dynamically bind into object model.  IO exception.", (Throwable)e);
        }
        finally {
            try {
                message.close();
            }
            catch (IOException e) {
                logger.debug((Object)"Exception closing message reader.", (Throwable)e);
            }
        }
    }

    private void configure() {
        Smooks smooks = this.descriptor.getSmooks();
        smooks.addVisitor((Visitor)new NamespaceReaper());
        smooks.setFilterSettings(FilterSettings.newDOMSettings());
        ParameterAccessor.setParameter((String)"org.milyn.javabean.notify.populate", (String)"true", (Smooks)smooks);
        smooks.createExecutionContext();
    }

    static {
        documentBuilderFactory.setNamespaceAware(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BeanTracker
    implements BeanContextLifecycleObserver {
        private List<BeanMetadata> beans = new ArrayList<BeanMetadata>();
        private Map<Class<?>, Map<String, BeanWriter>> beanWriterMap;

        public BeanTracker(Map<Class<?>, Map<String, BeanWriter>> beanWriterMap) {
            this.beanWriterMap = beanWriterMap;
        }

        public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
            if (event.getLifecycle() == BeanLifecycle.ADD || event.getLifecycle() == BeanLifecycle.CHANGE) {
                Object bean = event.getBean();
                BeanMetadata beanMetadata = new BeanMetadata(bean);
                Map<String, BeanWriter> beanWriters = this.beanWriterMap.get(bean.getClass());
                Fragment source = event.getSource();
                if (source != null) {
                    String namespaceURI = source.getNamespaceURI();
                    beanMetadata.setNamespace(namespaceURI);
                    beanMetadata.setNamespacePrefix(source.getPrefix());
                    beanMetadata.setCreateSource(source);
                    this.beans.add(beanMetadata);
                    if (source.isDOMElement()) {
                        beanMetadata.setPreText(UnknownElementDataReaper.getPreText(source.getDOMElement(), this.beans, event));
                    }
                    if (beanWriters != null) {
                        BeanWriter beanWriter = beanWriters.get(namespaceURI);
                        if (beanWriter != null) {
                            beanMetadata.setWriter(beanWriter);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug((Object)("BeanWriters are configured for Object type '" + bean.getClass() + "', but not for namespace '" + namespaceURI + "'."));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No BeanWriters configured for Object type '" + bean.getClass() + "'."));
                    }
                }
            } else if (event.getLifecycle() == BeanLifecycle.POPULATE) {
                BeanMetadata beanMetdata = this.findMetadata(event.getBean());
                beanMetdata.getPopulateSources().add(event.getSource());
            }
        }

        private BeanMetadata findMetadata(Object bean) {
            for (BeanMetadata metaData : this.beans) {
                if (metaData.getBean() != bean) continue;
                return metaData;
            }
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
            return null;
        }
    }
}

