/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.DateDecoder;

@DecodeType(value={XMLGregorianCalendar.class})
public class XMLGregorianCalendarDecoder
extends DateDecoder {
    public Object decode(String data) throws DataDecodeException {
        Date date = (Date)super.decode(data);
        try {
            GregorianCalendar gregCal = new GregorianCalendar();
            gregCal.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregCal);
        }
        catch (DatatypeConfigurationException e) {
            throw new DataDecodeException("Error decoding XMLGregorianCalendar data value '" + data + "' with decode format '" + this.format + "'.", (Throwable)e);
        }
    }

    public String encode(Object date) throws DataDecodeException {
        if (!(date instanceof XMLGregorianCalendar)) {
            throw new DataDecodeException("Cannot encode Object type '" + date.getClass().getName() + "'.  Must be type '" + XMLGregorianCalendar.class.getName() + "'.");
        }
        return super.encode(((XMLGregorianCalendar)date).toGregorianCalendar().getTime());
    }
}

