/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.milyn.edisax.model.internal.DelimiterType;

public class Delimiters {
    private String segment;
    private String field;
    private String fieldRepeat;
    private String component;
    private String subComponent;
    private String escape;
    private String decimalSeparator;
    private volatile char[] segmentDelimiter;
    private boolean ignoreCRLF;
    private Set<Character> delimiterChars = new LinkedHashSet<Character>();

    public String getSegment() {
        return this.segment;
    }

    public Delimiters setSegment(String value) {
        this.segment = value;
        this.initSegmentDelimiter();
        this.initDelimiterChars();
        return this;
    }

    public String getField() {
        return this.field;
    }

    public Delimiters setField(String value) {
        this.field = value;
        this.initDelimiterChars();
        return this;
    }

    public String getFieldRepeat() {
        return this.fieldRepeat;
    }

    public Delimiters setFieldRepeat(String fieldRepeat) {
        this.fieldRepeat = fieldRepeat;
        this.initDelimiterChars();
        return this;
    }

    public String getComponent() {
        return this.component;
    }

    public Delimiters setComponent(String value) {
        this.component = value;
        this.initDelimiterChars();
        return this;
    }

    public String getSubComponent() {
        return this.subComponent;
    }

    public Delimiters setSubComponent(String value) {
        this.subComponent = value;
        this.initDelimiterChars();
        return this;
    }

    public String getEscape() {
        return this.escape;
    }

    public Delimiters setEscape(String escape) {
        this.escape = escape;
        this.initDelimiterChars();
        return this;
    }

    public Delimiters setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        this.initDelimiterChars();
        return this;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char[] getSegmentDelimiter() {
        if (this.segmentDelimiter == null) {
            this.initSegmentDelimiter();
        }
        return this.segmentDelimiter;
    }

    public boolean ignoreCRLF() {
        if (this.segmentDelimiter == null) {
            this.initSegmentDelimiter();
        }
        return this.ignoreCRLF;
    }

    private synchronized void initSegmentDelimiter() {
        if (this.segmentDelimiter != null) {
            return;
        }
        this.ignoreCRLF = this.segment.endsWith("!$");
        this.segmentDelimiter = this.ignoreCRLF ? this.segment.replace("!$", "").toCharArray() : this.segment.toCharArray();
    }

    public boolean removeableNodeToken(String string, DelimiterType delimiterType) {
        if (string.length() == 0) {
            return true;
        }
        int stringLen = string.length();
        block7: for (int i = 0; i < stringLen; ++i) {
            char c = string.charAt(i);
            switch (delimiterType) {
                case SEGMENT: {
                    if (this.equals(this.segment, c)) continue block7;
                }
                case FIELD: {
                    if (this.equals(this.field, c)) continue block7;
                }
                case COMPONENT: {
                    if (this.equals(this.component, c)) continue block7;
                }
                case SUB_COMPONENT: {
                    if (this.equals(this.subComponent, c)) continue block7;
                }
                case DECIMAL_SEPARATOR: {
                    if (this.equals(this.decimalSeparator, c)) continue block7;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public String escape(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if (this.delimiterChars.isEmpty()) {
            return string;
        }
        StringBuilder escapeBuffer = new StringBuilder();
        int stringLen = string.length();
        for (int i = 0; i < stringLen; ++i) {
            char c = string.charAt(i);
            if (this.delimiterChars.contains(Character.valueOf(c))) {
                escapeBuffer.append(this.escape);
            }
            escapeBuffer.append(c);
        }
        return escapeBuffer.toString();
    }

    private void initDelimiterChars() {
        this.delimiterChars.clear();
        if (this.segmentDelimiter != null && (this.segmentDelimiter.length == 0 || this.segmentDelimiter.length > 1)) {
            return;
        }
        if (this.field != null && (this.field.length() == 0 || this.field.length() > 1)) {
            return;
        }
        if (this.fieldRepeat != null && (this.fieldRepeat.length() == 0 || this.fieldRepeat.length() > 1)) {
            return;
        }
        if (this.component != null && (this.component.length() == 0 || this.component.length() > 1)) {
            return;
        }
        if (this.subComponent != null && (this.subComponent.length() == 0 || this.subComponent.length() > 1)) {
            return;
        }
        if (this.escape == null || this.escape.length() == 0 || this.escape.length() > 1) {
            return;
        }
        if (this.segmentDelimiter != null) {
            this.delimiterChars.add(Character.valueOf(this.segmentDelimiter[0]));
        }
        if (this.field != null) {
            this.delimiterChars.add(Character.valueOf(this.field.charAt(0)));
        }
        if (this.fieldRepeat != null) {
            this.delimiterChars.add(Character.valueOf(this.fieldRepeat.charAt(0)));
        }
        if (this.component != null) {
            this.delimiterChars.add(Character.valueOf(this.component.charAt(0)));
        }
        if (this.subComponent != null) {
            this.delimiterChars.add(Character.valueOf(this.subComponent.charAt(0)));
        }
        if (this.escape != null) {
            this.delimiterChars.add(Character.valueOf(this.escape.charAt(0)));
        }
    }

    private boolean equals(String delimiter, char c) {
        return delimiter != null && delimiter.length() == 1 && delimiter.charAt(0) == c;
    }

    public Object clone() {
        Delimiters delimiters = new Delimiters();
        delimiters.segment = this.segment;
        delimiters.field = this.field;
        delimiters.fieldRepeat = this.fieldRepeat;
        delimiters.component = this.component;
        delimiters.subComponent = this.subComponent;
        delimiters.escape = this.escape;
        delimiters.decimalSeparator = this.decimalSeparator;
        delimiters.segmentDelimiter = this.segmentDelimiter;
        delimiters.ignoreCRLF = this.ignoreCRLF;
        delimiters.delimiterChars.addAll(this.delimiterChars);
        return delimiters;
    }
}

