/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.unedifact.d95b;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.milyn.ReaderConfigurator;
import org.milyn.Smooks;
import org.milyn.container.ExecutionContext;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.HtmlReportGenerator;
import org.milyn.payload.JavaResult;
import org.milyn.smooks.edi.unedifact.UNEdifactReaderConfigurator;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchange;
import org.milyn.smooks.edi.unedifact.model.UNEdifactInterchangeFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class D95BInterchangeFactory
implements UNEdifactInterchangeFactory {
    public static final String MAPPING_MODEL = "urn:org.milyn.edi.unedifact:d95b-mapping:1.7.1.0";
    public static final String INTERCHANGE_BINDING_CONFIG = "/org/milyn/edi/unedifact/d95b/interchange-bindingconfig.xml";
    private Smooks smooks = new Smooks();
    private String reportPath;

    public static D95BInterchangeFactory getInstance() throws IOException, SAXException {
        return new D95BInterchangeFactory();
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.smooks.addConfigurations(resourceConfigStream);
    }

    public UNEdifactInterchange fromUNEdifact(InputStream ediStream, Result ... additionalResults) throws IOException {
        return this.fromUNEdifact(new InputSource(ediStream), additionalResults);
    }

    public UNEdifactInterchange fromUNEdifact(InputSource ediSource, Result ... additionalResults) throws IOException {
        StreamSource streamSource = new StreamSource();
        streamSource.setInputStream(ediSource.getByteStream());
        streamSource.setReader(ediSource.getCharacterStream());
        JavaResult javaResult = new JavaResult();
        int numAdditionalRes = additionalResults != null ? additionalResults.length : 0;
        Result[] results = new Result[numAdditionalRes + 1];
        results[0] = javaResult;
        if (additionalResults != null) {
            System.arraycopy(additionalResults, 0, results, 1, numAdditionalRes);
        }
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        if (this.reportPath != null) {
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator(this.reportPath));
        }
        this.smooks.filterSource(executionContext, (Source)streamSource, results);
        return (UNEdifactInterchange)javaResult.getBean(UNEdifactInterchange.class);
    }

    public void toUNEdifact(UNEdifactInterchange interchange, Writer writer) throws IOException {
        interchange.write(writer);
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    private D95BInterchangeFactory() throws IOException, SAXException {
        try {
            this.smooks.setReaderConfig((ReaderConfigurator)new UNEdifactReaderConfigurator(MAPPING_MODEL));
        }
        catch (EDIConfigurationException e) {
            IOException ioException = new IOException("Exception reading UN/EDIFACT Mapping model.");
            ioException.initCause(e);
            throw ioException;
        }
        this.smooks.addConfigurations(INTERCHANGE_BINDING_CONFIG);
    }
}

