/**
 * This class was generated by Smooks EJC (http://www.smooks.org).
 */
package org.milyn.edi.unedifact.d95b.common;

import java.io.Serializable;    
import org.milyn.smooks.edi.EDIWritable;    
import java.math.BigDecimal;    
import org.milyn.javabean.decoders.DABigDecimalDecoder;    
import java.io.Writer;    
import org.milyn.edisax.model.internal.Delimiters;    
import java.io.IOException;    
import java.io.StringWriter;    
import java.util.List;    
import java.util.ArrayList;    
import org.milyn.edisax.util.EDIUtils;    
import org.milyn.edisax.model.internal.DelimiterType;    

public class DMSDocumentMessageSummary implements Serializable, EDIWritable {

    private static final long serialVersionUID = 1L;

    private String e1004DocumentMessageNumber;
    private String e1001DocumentMessageNameCoded;
    private BigDecimal e7240TotalNumberOfItems;
    private DABigDecimalDecoder e7240TotalNumberOfItemsEncoder;

    public DMSDocumentMessageSummary() {
        
        e7240TotalNumberOfItemsEncoder = new DABigDecimalDecoder();
    }

    public void write(Writer writer, Delimiters delimiters) throws IOException {
        
        Writer nodeWriter = new StringWriter();

        List<String> nodeTokens = new ArrayList<String>();

        if(e1004DocumentMessageNumber != null) {
            nodeWriter.write(delimiters.escape(e1004DocumentMessageNumber.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e1001DocumentMessageNameCoded != null) {
            nodeWriter.write(delimiters.escape(e1001DocumentMessageNameCoded.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e7240TotalNumberOfItems != null) {
            nodeWriter.write(delimiters.escape(e7240TotalNumberOfItemsEncoder.encode(e7240TotalNumberOfItems, delimiters)));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeTokens.add(nodeWriter.toString());
        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.FIELD, delimiters));
        writer.write(delimiters.getSegmentDelimiter());
        writer.flush();
    }

    public String getE1004DocumentMessageNumber() {
        return e1004DocumentMessageNumber;
    }

    public DMSDocumentMessageSummary setE1004DocumentMessageNumber(String e1004DocumentMessageNumber) {
        this.e1004DocumentMessageNumber = e1004DocumentMessageNumber;  return this;
    }

    public String getE1001DocumentMessageNameCoded() {
        return e1001DocumentMessageNameCoded;
    }

    public DMSDocumentMessageSummary setE1001DocumentMessageNameCoded(String e1001DocumentMessageNameCoded) {
        this.e1001DocumentMessageNameCoded = e1001DocumentMessageNameCoded;  return this;
    }

    public BigDecimal getE7240TotalNumberOfItems() {
        return e7240TotalNumberOfItems;
    }

    public DMSDocumentMessageSummary setE7240TotalNumberOfItems(BigDecimal e7240TotalNumberOfItems) {
        this.e7240TotalNumberOfItems = e7240TotalNumberOfItems;  return this;
    }
}