/**
 * This class was generated by Smooks EJC (http://www.smooks.org).
 */
package org.milyn.edi.unedifact.d95b.common;

import java.io.Serializable;    
import org.milyn.smooks.edi.EDIWritable;    
import java.io.Writer;    
import org.milyn.edisax.model.internal.Delimiters;    
import java.io.IOException;    
import java.io.StringWriter;    
import java.util.List;    
import java.util.ArrayList;    
import org.milyn.edisax.util.EDIUtils;    
import org.milyn.edisax.model.internal.DelimiterType;    

public class DIIDirectoryIdentification implements Serializable, EDIWritable {

    private static final long serialVersionUID = 1L;

    private String e1056Version;
    private String e1058Release;
    private String e9148DirectoryStatus;
    private String e1476ControlAgency;
    private String e3453LanguageCoded;
    private String e4513MaintenanceOperationCoded;

    public void write(Writer writer, Delimiters delimiters) throws IOException {
        
        Writer nodeWriter = new StringWriter();

        List<String> nodeTokens = new ArrayList<String>();

        if(e1056Version != null) {
            nodeWriter.write(delimiters.escape(e1056Version.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e1058Release != null) {
            nodeWriter.write(delimiters.escape(e1058Release.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e9148DirectoryStatus != null) {
            nodeWriter.write(delimiters.escape(e9148DirectoryStatus.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e1476ControlAgency != null) {
            nodeWriter.write(delimiters.escape(e1476ControlAgency.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e3453LanguageCoded != null) {
            nodeWriter.write(delimiters.escape(e3453LanguageCoded.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e4513MaintenanceOperationCoded != null) {
            nodeWriter.write(delimiters.escape(e4513MaintenanceOperationCoded.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeTokens.add(nodeWriter.toString());
        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.FIELD, delimiters));
        writer.write(delimiters.getSegmentDelimiter());
        writer.flush();
    }

    public String getE1056Version() {
        return e1056Version;
    }

    public DIIDirectoryIdentification setE1056Version(String e1056Version) {
        this.e1056Version = e1056Version;  return this;
    }

    public String getE1058Release() {
        return e1058Release;
    }

    public DIIDirectoryIdentification setE1058Release(String e1058Release) {
        this.e1058Release = e1058Release;  return this;
    }

    public String getE9148DirectoryStatus() {
        return e9148DirectoryStatus;
    }

    public DIIDirectoryIdentification setE9148DirectoryStatus(String e9148DirectoryStatus) {
        this.e9148DirectoryStatus = e9148DirectoryStatus;  return this;
    }

    public String getE1476ControlAgency() {
        return e1476ControlAgency;
    }

    public DIIDirectoryIdentification setE1476ControlAgency(String e1476ControlAgency) {
        this.e1476ControlAgency = e1476ControlAgency;  return this;
    }

    public String getE3453LanguageCoded() {
        return e3453LanguageCoded;
    }

    public DIIDirectoryIdentification setE3453LanguageCoded(String e3453LanguageCoded) {
        this.e3453LanguageCoded = e3453LanguageCoded;  return this;
    }

    public String getE4513MaintenanceOperationCoded() {
        return e4513MaintenanceOperationCoded;
    }

    public DIIDirectoryIdentification setE4513MaintenanceOperationCoded(String e4513MaintenanceOperationCoded) {
        this.e4513MaintenanceOperationCoded = e4513MaintenanceOperationCoded;  return this;
    }
}