/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edi.unedifact.d00b.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.milyn.Smooks;
import org.milyn.edi.unedifact.d00b.common.DefinitionMap;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.EDIConfigDigester;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.payload.JavaResult;
import org.xml.sax.SAXException;

public class DefinitionMapFactory {
    private Smooks smooks = new Smooks(DefinitionMapFactory.class.getResourceAsStream("bindingconfig.xml"));
    private Delimiters delimiters;

    public static DefinitionMapFactory getInstance() throws IOException, SAXException {
        return new DefinitionMapFactory();
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.smooks.addConfigurations(resourceConfigStream);
    }

    public DefinitionMap fromEDI(InputStream ediStream, Result ... additionalResults) {
        return this.fromEDI(new InputStreamReader(ediStream), additionalResults);
    }

    public DefinitionMap fromEDI(Reader ediStream, Result ... additionalResults) {
        JavaResult javaResult = new JavaResult();
        int numAdditionalRes = additionalResults != null ? additionalResults.length : 0;
        Result[] results = new Result[numAdditionalRes + 1];
        results[0] = javaResult;
        if (additionalResults != null) {
            System.arraycopy(additionalResults, 0, results, 1, numAdditionalRes);
        }
        this.smooks.filterSource((Source)new StreamSource(ediStream), results);
        return (DefinitionMap)javaResult.getBean(DefinitionMap.class);
    }

    public void toEDI(DefinitionMap instance, Writer writer) throws IOException {
        instance.write(writer, this.delimiters);
    }

    private DefinitionMapFactory() throws IOException, SAXException {
        try {
            Edimap edimap = EDIConfigDigester.digestConfig((InputStream)DefinitionMapFactory.class.getResourceAsStream("edimappingconfig.xml"));
            this.delimiters = edimap.getDelimiters();
        }
        catch (EDIConfigurationException e) {
            IOException ioException = new IOException("Exception reading EDI Mapping model.");
            ioException.initCause(e);
            throw ioException;
        }
    }
}

