/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import java.util.ArrayList;
import java.util.List;
import org.michaelbel.bottomsheet.menu.BottomSheetMenuItem;

public class BottomSheetMenu
implements Menu {
    private Context mContext;
    private boolean mIsQwerty;
    private ArrayList<BottomSheetMenuItem> mItems;

    public BottomSheetMenu(Context context) {
        this.mContext = context;
        this.mItems = new ArrayList();
    }

    public Context getContext() {
        return this.mContext;
    }

    public MenuItem add(CharSequence title) {
        return this.add(0, 0, 0, title);
    }

    public MenuItem add(int titleRes) {
        return this.add(0, 0, 0, titleRes);
    }

    public MenuItem add(int groupId, int itemId, int order, int titleRes) {
        return this.add(groupId, itemId, order, this.mContext.getResources().getString(titleRes));
    }

    public MenuItem add(int groupId, int itemId, int order, CharSequence title) {
        BottomSheetMenuItem item = new BottomSheetMenuItem(this.getContext(), groupId, itemId, 0, order, title);
        this.mItems.add(item);
        return item;
    }

    public int addIntentOptions(int groupId, int itemId, int order, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        int N;
        PackageManager pm = this.mContext.getPackageManager();
        List lri = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        int n = N = lri != null ? lri.size() : 0;
        if ((flags & 1) == 0) {
            this.removeGroup(groupId);
        }
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = (ResolveInfo)lri.get(i);
            Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
            rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
            MenuItem item = this.add(groupId, itemId, order, ri.loadLabel(pm)).setIcon(ri.loadIcon(pm)).setIntent(rintent);
            if (outSpecificItems == null || ri.specificIndex < 0) continue;
            outSpecificItems[ri.specificIndex] = item;
        }
        return N;
    }

    public SubMenu addSubMenu(CharSequence title) {
        return null;
    }

    public SubMenu addSubMenu(int titleRes) {
        return null;
    }

    public SubMenu addSubMenu(int groupId, int itemId, int order, CharSequence title) {
        return null;
    }

    public SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes) {
        return null;
    }

    public void clear() {
        this.mItems.clear();
    }

    public void close() {
    }

    private int findItemIndex(int id) {
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            if (items.get(i).getItemId() != id) continue;
            return i;
        }
        return -1;
    }

    public MenuItem findItem(int id) {
        return this.mItems.get(this.findItemIndex(id));
    }

    public MenuItem getItem(int index) {
        return this.mItems.get(index);
    }

    public boolean hasVisibleItems() {
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            if (!items.get(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    private BottomSheetMenuItem findItemWithShortcut(int keyCode, KeyEvent event) {
        boolean qwerty = this.mIsQwerty;
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            char shortcut;
            BottomSheetMenuItem item = items.get(i);
            char c = shortcut = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if (keyCode != shortcut) continue;
            return item;
        }
        return null;
    }

    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        return this.findItemWithShortcut(keyCode, event) != null;
    }

    public boolean performIdentifierAction(int id, int flags) {
        int index = this.findItemIndex(id);
        if (index < 0) {
            return false;
        }
        return this.mItems.get(index).invoke();
    }

    public boolean performShortcut(int keyCode, KeyEvent event, int flags) {
        BottomSheetMenuItem item = this.findItemWithShortcut(keyCode, event);
        if (item == null) {
            return false;
        }
        return item.invoke();
    }

    public void removeGroup(int groupId) {
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        int i = 0;
        while (i < itemCount) {
            if (items.get(i).getGroupId() == groupId) {
                items.remove(i);
                --itemCount;
                continue;
            }
            ++i;
        }
    }

    public void removeItem(int id) {
        this.mItems.remove(this.findItemIndex(id));
    }

    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            BottomSheetMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setCheckable(checkable);
            item.setExclusiveCheckable(exclusive);
        }
    }

    public void setGroupEnabled(int group, boolean enabled) {
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            BottomSheetMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setEnabled(enabled);
        }
    }

    public void setGroupVisible(int group, boolean visible) {
        ArrayList<BottomSheetMenuItem> items = this.mItems;
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            BottomSheetMenuItem item = items.get(i);
            if (item.getGroupId() != group) continue;
            item.setVisible(visible);
        }
    }

    public void setQwertyMode(boolean isQwerty) {
        this.mIsQwerty = isQwerty;
    }

    public int size() {
        return this.mItems.size();
    }
}

