/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.BoolRes;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.michaelbel.bottomsheet.BottomSheetCallback;
import org.michaelbel.bottomsheet.BottomSheetCell;
import org.michaelbel.bottomsheet.BottomSheetGrid;
import org.michaelbel.bottomsheet.BottomSheetItem;
import org.michaelbel.bottomsheet.menu.BottomSheetMenu;
import org.michaelbel.bottomsheetdialog.R;
import org.michaelbel.bottomsheetdialog.Utils;

public class BottomSheet
extends Dialog {
    private static final String TAG = BottomSheet.class.getSimpleName();
    public static final int LIST = 1;
    public static final int GRID = 2;
    public static final int LIGHT_THEME = 10;
    public static final int DARK_THEME = 11;
    private boolean dividers;
    private boolean fullWidth;
    private boolean darkTheme;
    private boolean titleTextMultiline;
    private int cellHeight;
    private int itemSelector;
    private int dimmingValue = 80;
    private int contentType = 1;
    private int theme = 10;
    @ColorInt
    private int titleTextColor;
    @ColorInt
    private int backgroundColor;
    @ColorInt
    private int iconColor;
    @ColorInt
    private int itemTextColor;
    private View customView;
    private TextView titleTextView;
    private ListView listView;
    private GridView gridView;
    private ContainerView container;
    private LinearLayout containerView;
    private List<Drawable> ICONS = new ArrayList<Drawable>();
    private List<CharSequence> ITEMS = new ArrayList<CharSequence>();
    private CharSequence titleText;
    private ArrayList<BottomSheetItem> bottomsheetItems = new ArrayList();
    private WindowInsets lastInsets;
    private Runnable startAnimationRunnable;
    private int layoutCount;
    private boolean dismissed;
    private ColorDrawable backDrawable = new ColorDrawable(-16777216);
    private boolean allowCustomAnimation = true;
    private int touchSlop;
    private boolean useFastDismiss;
    private boolean focusable;
    private Drawable shadowDrawable;
    private static int backgroundPaddingTop;
    private static int backgroundPaddingLeft;
    private AnimatorSet currentSheetAnimation;
    private Point displaySize = new Point();
    private DisplayMetrics metrics = new DisplayMetrics();
    private Handler handler = new Handler(Looper.getMainLooper());
    private DialogInterface.OnClickListener onClickListener;
    private BottomSheetCallback bottomSheetCallback;

    protected void onCreate(Bundle savedInstanceState) {
        Window window;
        super.onCreate(savedInstanceState);
        if (this.backgroundColor == 0) {
            int n = this.backgroundColor = this.darkTheme ? -12434878 : -1;
        }
        if (this.titleTextColor == 0) {
            int n = this.titleTextColor = this.darkTheme ? -1275068417 : -1979711488;
        }
        if (this.itemTextColor == 0) {
            int n = this.itemTextColor = this.darkTheme ? -1 : -570425344;
        }
        if (this.iconColor == 0) {
            int n = this.iconColor = this.darkTheme ? -1 : -1979711488;
        }
        if (this.itemSelector == 0) {
            int n = this.itemSelector = this.darkTheme ? R.drawable.selectable_dark : R.drawable.selectable_light;
        }
        if (this.cellHeight == 0) {
            this.cellHeight = org.michaelbel.bottomsheet.Utils.dp(this.getContext(), 48.0f);
        }
        if ((window = this.getWindow()) != null) {
            window.setWindowAnimations(R.style.DialogNoAnimation);
        }
        this.setContentView((View)this.container, new ViewGroup.LayoutParams(-1, -1));
        if (this.containerView == null) {
            this.containerView = new LinearLayout(this.getContext()){

                public boolean hasOverlappingRendering() {
                    return false;
                }
            };
            this.containerView.setOrientation(1);
            if (Build.VERSION.SDK_INT >= 16) {
                this.containerView.setBackground(this.shadowDrawable);
            } else {
                this.containerView.setBackgroundDrawable(this.shadowDrawable);
            }
            this.containerView.setPadding(0, backgroundPaddingTop, 0, Utils.dp(this.getContext(), 8.0f));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.containerView.setFitsSystemWindows(true);
        }
        this.containerView.setVisibility(4);
        this.containerView.setBackgroundColor(this.backgroundColor);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.container.addView((View)this.containerView, 0);
        if (this.customView != null) {
            if (this.customView.getParent() != null) {
                ViewGroup viewGroup = (ViewGroup)this.customView.getParent();
                viewGroup.removeView(this.customView);
            }
            FrameLayout.LayoutParams params1 = (FrameLayout.LayoutParams)this.containerView.getLayoutParams();
            params1.width = -1;
            params1.height = -2;
            params1.gravity = 0x800033;
            this.containerView.addView(this.customView, (ViewGroup.LayoutParams)params1);
        } else {
            if (this.titleText != null) {
                this.titleTextView = new TextView(this.getContext());
                this.titleTextView.setLines(1);
                this.titleTextView.setText(this.titleText);
                this.titleTextView.setTextColor(this.titleTextColor);
                this.titleTextView.setGravity(16);
                this.titleTextView.setEllipsize(TextUtils.TruncateAt.END);
                this.titleTextView.setTextSize(1, 16.0f);
                if (this.titleTextMultiline) {
                    this.titleTextView.setSingleLine(false);
                } else {
                    this.titleTextView.setMaxLines(1);
                    this.titleTextView.setSingleLine(true);
                }
                LinearLayout.LayoutParams params0 = new LinearLayout.LayoutParams(-2, -2);
                params0.gravity = 0x800033;
                params0.leftMargin = Utils.dp(this.getContext(), 16.0f);
                params0.rightMargin = Utils.dp(this.getContext(), 16.0f);
                params0.topMargin = Utils.dp(this.getContext(), 8.0f);
                params0.bottomMargin = Utils.dp(this.getContext(), 16.0f);
                this.titleTextView.setLayoutParams((ViewGroup.LayoutParams)params0);
                this.containerView.addView((View)this.titleTextView);
                this.titleTextView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        return true;
                    }
                });
            }
            BottomSheetAdapter adapter = new BottomSheetAdapter();
            if (!this.ITEMS.isEmpty()) {
                if (this.contentType == 1) {
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-1, -2);
                    this.listView = new ListView(this.getContext());
                    this.listView.setSelector(this.itemSelector);
                    this.listView.setDividerHeight(0);
                    this.listView.setAdapter((ListAdapter)adapter);
                    this.listView.setDrawSelectorOnTop(true);
                    this.listView.setVerticalScrollBarEnabled(false);
                    this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                            BottomSheet.this.dismissWithButtonClick(position);
                        }
                    });
                    this.listView.setLayoutParams((ViewGroup.LayoutParams)params2);
                    this.containerView.addView((View)this.listView);
                } else if (this.contentType == 2) {
                    LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams(-1, -2);
                    this.gridView = new GridView(this.getContext());
                    this.gridView.setSelector(this.itemSelector);
                    this.gridView.setAdapter((ListAdapter)adapter);
                    this.gridView.setNumColumns(3);
                    this.gridView.setVerticalScrollBarEnabled(false);
                    this.gridView.setVerticalSpacing(org.michaelbel.bottomsheet.Utils.dp(this.getContext(), 16.0f));
                    this.gridView.setPadding(org.michaelbel.bottomsheet.Utils.dp(this.getContext(), 0.0f), org.michaelbel.bottomsheet.Utils.dp(this.getContext(), 8.0f), Utils.dp(this.getContext(), 0.0f), Utils.dp(this.getContext(), 16.0f));
                    this.gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                            BottomSheet.this.dismissWithButtonClick(i);
                        }
                    });
                    this.gridView.setLayoutParams((ViewGroup.LayoutParams)params3);
                    this.containerView.addView((View)this.gridView);
                }
                if (!this.ITEMS.isEmpty()) {
                    for (int a = 0; a < this.ITEMS.size(); ++a) {
                        this.bottomsheetItems.add(new BottomSheetItem(this.ITEMS.get(a), !this.ICONS.isEmpty() ? this.ICONS.get(a) : null));
                    }
                }
                adapter.notifyDataSetChanged();
            }
        }
        WindowManager.LayoutParams params4 = window.getAttributes();
        params4.width = -1;
        params4.gravity = 0x800033;
        params4.dimAmount = 0.0f;
        params4.flags &= 0xFFFFFFFD;
        if (!this.focusable) {
            params4.flags |= 0x20000;
        }
        params4.height = -1;
        window.setAttributes(params4);
    }

    public void show() {
        super.show();
        if (this.focusable) {
            try {
                this.getWindow().setSoftInputMode(16);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dismissed = false;
        this.cancelSheetAnimation();
        if (this.containerView.getMeasuredHeight() == 0) {
            this.containerView.measure(View.MeasureSpec.makeMeasureSpec((int)this.displaySize.x, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.displaySize.y, (int)Integer.MIN_VALUE));
        }
        this.backDrawable.setAlpha(0);
        if (Build.VERSION.SDK_INT >= 18) {
            this.layoutCount = 2;
            this.startAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    if (BottomSheet.this.startAnimationRunnable != this) {
                        return;
                    }
                    BottomSheet.this.startAnimationRunnable = null;
                    BottomSheet.this.startOpenAnimation();
                }
            };
            this.handler.postDelayed(this.startAnimationRunnable, 150L);
        } else {
            this.startOpenAnimation();
        }
        if (this.bottomSheetCallback != null) {
            this.bottomSheetCallback.onShown();
        }
    }

    public void dismiss() {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.cancelSheetAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getMeasuredHeight() + Utils.dp(this.getContext(), 10.0f)}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{0})});
        if (this.useFastDismiss) {
            int height = this.containerView.getMeasuredHeight();
            animatorSet.setDuration((long)Math.max(60, (int)(180.0f * ((float)height - this.containerView.getTranslationY()) / (float)height)));
            this.useFastDismiss = false;
        } else {
            animatorSet.setDuration(180L);
        }
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    BottomSheet.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BottomSheet.this.dismissInternal();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
        if (this.bottomSheetCallback != null) {
            this.bottomSheetCallback.onDismissed();
        }
    }

    private BottomSheet(Context context, boolean needFocus) {
        super(context, R.style.TransparentDialog);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().addFlags(-2147417856);
        }
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
        Rect padding = new Rect();
        this.shadowDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.sheet_shadow);
        this.shadowDrawable.getPadding(padding);
        backgroundPaddingLeft = padding.left;
        backgroundPaddingTop = padding.top;
        this.container = new ContainerView(this.getContext());
        if (Build.VERSION.SDK_INT >= 16) {
            this.container.setBackground((Drawable)this.backDrawable);
        } else {
            this.container.setBackgroundDrawable((Drawable)this.backDrawable);
        }
        this.focusable = needFocus;
        if (Build.VERSION.SDK_INT >= 21) {
            this.container.setFitsSystemWindows(true);
            this.container.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                @SuppressLint(value={"NewApi"})
                public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                    BottomSheet.this.lastInsets = insets;
                    v.requestLayout();
                    return insets.consumeSystemWindowInsets();
                }
            });
            this.container.setSystemUiVisibility(1280);
        }
        this.backDrawable.setAlpha(0);
    }

    private boolean onContainerTouchEvent(MotionEvent event) {
        return false;
    }

    private boolean canDismissWithSwipe() {
        return true;
    }

    private boolean canDismissWithTouchOutside() {
        return true;
    }

    private void cancelSheetAnimation() {
        if (this.currentSheetAnimation != null) {
            this.currentSheetAnimation.cancel();
            this.currentSheetAnimation = null;
        }
    }

    private void startOpenAnimation() {
        this.containerView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 20) {
            this.container.setLayerType(2, null);
        }
        this.containerView.setTranslationY((float)this.containerView.getMeasuredHeight());
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{this.dimmingValue})});
        animatorSet.setDuration(200L);
        animatorSet.setStartDelay(20L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    BottomSheet.this.container.setLayerType(0, null);
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
    }

    private void dismissWithButtonClick(final int viewId) {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.cancelSheetAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getMeasuredHeight() + org.michaelbel.bottomsheet.Utils.dp(this.getContext(), 10.0f)}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{0})});
        animatorSet.setDuration(180L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    if (BottomSheet.this.onClickListener != null) {
                        BottomSheet.this.onClickListener.onClick((DialogInterface)BottomSheet.this, viewId);
                    }
                    BottomSheet.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BottomSheet.super.dismiss();
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)e.getMessage());
                            }
                        }
                    });
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
        if (this.bottomSheetCallback != null) {
            this.bottomSheetCallback.onDismissed();
        }
    }

    private void dismissInternal() {
        super.dismiss();
    }

    private float getPixelsInCM(float cm, boolean isX) {
        return cm / 2.54f * (isX ? this.metrics.xdpi : this.metrics.ydpi);
    }

    private class BottomSheetAdapter
    extends BaseAdapter {
        private BottomSheetAdapter() {
        }

        public int getCount() {
            return BottomSheet.this.ITEMS != null ? BottomSheet.this.ITEMS.size() : 0;
        }

        public Object getItem(int i) {
            return null;
        }

        public long getItemId(int i) {
            return 0L;
        }

        public View getView(int position, View view, ViewGroup viewGroup) {
            int type = this.getItemViewType(position);
            BottomSheetItem item = (BottomSheetItem)BottomSheet.this.bottomsheetItems.get(position);
            if (type == 0) {
                if (BottomSheet.this.contentType == 1) {
                    if (view == null) {
                        view = new BottomSheetCell(BottomSheet.this.getContext());
                    }
                    BottomSheetCell cell = (BottomSheetCell)((Object)view);
                    cell.setIcon(item.icon, BottomSheet.this.iconColor);
                    cell.setText(item.text, BottomSheet.this.itemTextColor);
                    cell.setHeight(BottomSheet.this.cellHeight);
                    if (position != BottomSheet.this.bottomsheetItems.size() - 1) {
                        cell.setDivider(BottomSheet.this.dividers);
                        cell.setDividerColor(BottomSheet.this.darkTheme);
                    }
                } else {
                    if (view == null) {
                        view = new BottomSheetGrid(BottomSheet.this.getContext());
                    }
                    BottomSheetGrid cell = (BottomSheetGrid)((Object)view);
                    cell.setIcon(item.icon, BottomSheet.this.iconColor);
                    cell.setText(item.text, BottomSheet.this.itemTextColor);
                }
            }
            return view;
        }

        public int getItemViewType(int i) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }
    }

    public static class Builder {
        private Context context;
        private BottomSheet bottomSheet;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, false);
        }

        public Builder(@NonNull Context context, boolean focus) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, focus);
        }

        public Builder(@NonNull Context context, @BoolRes int needFocus) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, context.getResources().getBoolean(needFocus));
        }

        public Builder setItems(@NonNull CharSequence[] items, DialogInterface.OnClickListener onClickListener) {
            this.bottomSheet.ITEMS.addAll(Arrays.asList(items));
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setContentType(int type) {
            this.bottomSheet.contentType = type;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.bottomSheet.backgroundColor = color;
            return this;
        }

        public Builder setItems(@StringRes int[] items, DialogInterface.OnClickListener onClickListener) {
            for (int i : items) {
                this.bottomSheet.ITEMS.add(this.context.getResources().getString(i));
            }
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setItems(@NonNull CharSequence[] items, int[] icons, DialogInterface.OnClickListener onClickListener) {
            this.bottomSheet.ITEMS.addAll(Arrays.asList(items));
            for (int i : icons) {
                this.bottomSheet.ICONS.add(ContextCompat.getDrawable((Context)this.context, (int)i));
            }
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setItems(@StringRes int[] items, int[] icons, DialogInterface.OnClickListener onClickListener) {
            for (int i : items) {
                this.bottomSheet.ITEMS.add(this.context.getResources().getString(i));
            }
            for (int j : icons) {
                this.bottomSheet.ICONS.add(ContextCompat.getDrawable((Context)this.context, (int)j));
            }
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setView(@NonNull View view) {
            this.bottomSheet.customView = view;
            return this;
        }

        public Builder setView(@LayoutRes int layoutId) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
            this.setView(layoutInflater.inflate(layoutId, null));
            return this;
        }

        public Builder setTitle(@NonNull CharSequence text) {
            this.bottomSheet.titleText = text;
            return this;
        }

        public Builder setTitle(@StringRes int textId) {
            this.setTitle(this.context.getText(textId));
            return this;
        }

        public Builder setTitleTextColor(@ColorInt int color) {
            this.bottomSheet.titleTextColor = color;
            return this;
        }

        public Builder setItemTextColor(@ColorInt int color) {
            this.bottomSheet.itemTextColor = color;
            return this;
        }

        public Builder setDarkTheme(boolean value) {
            this.bottomSheet.darkTheme = value;
            return this;
        }

        public Builder setDarkTheme(@BoolRes int value) {
            this.bottomSheet.darkTheme = this.context.getResources().getBoolean(value);
            return this;
        }

        public Builder setIconColor(@ColorInt int color) {
            this.bottomSheet.iconColor = color;
            return this;
        }

        public Builder setFullWidth(boolean value) {
            this.bottomSheet.fullWidth = value;
            return this;
        }

        public Builder setFullWidth(@BoolRes int value) {
            this.bottomSheet.fullWidth = this.context.getResources().getBoolean(value);
            return this;
        }

        public Builder setItemSelector(int selector) {
            this.bottomSheet.itemSelector = selector;
            return this;
        }

        public Builder setCellHeight(int height) {
            this.bottomSheet.cellHeight = height;
            return this;
        }

        public Builder setMenu(@MenuRes int menuId, DialogInterface.OnClickListener onClickListener) {
            BottomSheetMenu menu = new BottomSheetMenu(this.context);
            new MenuInflater(this.context).inflate(menuId, (Menu)menu);
            for (int i = 0; i < menu.size(); ++i) {
                this.bottomSheet.ITEMS.add(menu.getItem(i).getTitle());
                this.bottomSheet.ICONS.add(menu.getItem(i).getIcon());
            }
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setDividers(boolean value) {
            this.bottomSheet.dividers = value;
            return this;
        }

        public Builder setDividers(@BoolRes int value) {
            this.bottomSheet.dividers = this.context.getResources().getBoolean(value);
            return this;
        }

        public Builder setTitleMultiline(boolean state) {
            this.bottomSheet.titleTextMultiline = state;
            return this;
        }

        public Builder setTitleMultiline(@BoolRes int value) {
            this.bottomSheet.titleTextMultiline = this.context.getResources().getBoolean(value);
            return this;
        }

        public Builder setWindowDimming(@IntRange(from=0L, to=255L) int value) {
            this.bottomSheet.dimmingValue = value;
            return this;
        }

        public Builder setCallback(@NonNull BottomSheetCallback callback) {
            this.bottomSheet.bottomSheetCallback = callback;
            return this;
        }

        public BottomSheet show() {
            this.bottomSheet.show();
            return this.bottomSheet;
        }

        public TextView getTitleTextView() {
            return this.bottomSheet.titleTextView;
        }

        public ListView getListView() {
            return this.bottomSheet.listView;
        }

        public GridView getGridView() {
            return this.bottomSheet.gridView;
        }

        @Deprecated
        public Builder setCustomView(@NonNull View view) {
            this.bottomSheet.customView = view;
            return this;
        }

        @Deprecated
        public Builder setCustomView(@LayoutRes int layoutId) {
            this.setCustomView(LayoutInflater.from((Context)this.context).inflate(layoutId, null));
            return this;
        }
    }

    private class ContainerView
    extends FrameLayout
    implements NestedScrollingParent {
        private int startedTrackingX;
        private int startedTrackingY;
        private int startedTrackingPointerId;
        private boolean maybeStartTracking;
        private boolean startedTracking;
        private AnimatorSet currentAnimation;
        private VelocityTracker velocityTracker;
        private NestedScrollingParentHelper nestedScrollingParentHelper;

        public ContainerView(Context context) {
            super(context);
            this.maybeStartTracking = false;
            this.startedTracking = false;
            this.currentAnimation = null;
            this.velocityTracker = null;
            this.nestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        }

        public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
            return !BottomSheet.this.dismissed && nestedScrollAxes == 2 && !BottomSheet.this.canDismissWithSwipe();
        }

        public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
            this.nestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
        }

        public void onStopNestedScroll(@NonNull View target) {
            this.nestedScrollingParentHelper.onStopNestedScroll(target);
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.checkDismiss(0.0f, 0.0f);
        }

        public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
            if (dyUnconsumed != 0) {
                float currentTranslation = BottomSheet.this.containerView.getTranslationY();
                if ((currentTranslation -= (float)dyUnconsumed) < 0.0f) {
                    currentTranslation = 0.0f;
                }
                BottomSheet.this.containerView.setTranslationY(currentTranslation);
            }
        }

        public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
            float currentTranslation = BottomSheet.this.containerView.getTranslationY();
            if (currentTranslation > 0.0f && dy > 0) {
                currentTranslation -= (float)dy;
                consumed[1] = dy;
                if (currentTranslation < 0.0f) {
                    currentTranslation = 0.0f;
                    consumed[1] = (int)((float)consumed[1] + currentTranslation);
                }
                BottomSheet.this.containerView.setTranslationY(currentTranslation);
            }
        }

        public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
            return false;
        }

        public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
            return false;
        }

        public int getNestedScrollAxes() {
            return this.nestedScrollingParentHelper.getNestedScrollAxes();
        }

        private void checkDismiss(float velX, float velY) {
            boolean backAnimation;
            float translationY = BottomSheet.this.containerView.getTranslationY();
            boolean bl = backAnimation = translationY < BottomSheet.this.getPixelsInCM(0.8f, false) && (velY < 3500.0f || Math.abs(velY) < Math.abs(velX)) || velY < 0.0f && Math.abs(velY) >= 3500.0f;
            if (!backAnimation) {
                boolean allowOld = BottomSheet.this.allowCustomAnimation;
                BottomSheet.this.allowCustomAnimation = false;
                BottomSheet.this.useFastDismiss = true;
                BottomSheet.this.dismiss();
                BottomSheet.this.allowCustomAnimation = allowOld;
            } else {
                this.currentAnimation = new AnimatorSet();
                this.currentAnimation.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)BottomSheet.this.containerView, (String)"translationY", (float[])new float[]{0.0f})});
                this.currentAnimation.setDuration((long)((int)(150.0f * (translationY / BottomSheet.this.getPixelsInCM(0.8f, false)))));
                this.currentAnimation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.currentAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (ContainerView.this.currentAnimation != null && ContainerView.this.currentAnimation.equals(animation)) {
                            ContainerView.this.currentAnimation = null;
                        }
                    }
                });
                this.currentAnimation.start();
            }
        }

        private void cancelCurrentAnimation() {
            if (this.currentAnimation != null) {
                this.currentAnimation.cancel();
                this.currentAnimation = null;
            }
        }

        public boolean onTouchEvent(MotionEvent ev) {
            if (BottomSheet.this.dismissed) {
                return false;
            }
            if (BottomSheet.this.onContainerTouchEvent(ev)) {
                return true;
            }
            if (!(!BottomSheet.this.canDismissWithTouchOutside() || ev == null || ev.getAction() != 0 && ev.getAction() != 2 || this.startedTracking || this.maybeStartTracking)) {
                this.startedTrackingX = (int)ev.getX();
                this.startedTrackingY = (int)ev.getY();
                if (this.startedTrackingY < BottomSheet.this.containerView.getTop() || this.startedTrackingX < BottomSheet.this.containerView.getLeft() || this.startedTrackingX > BottomSheet.this.containerView.getRight()) {
                    BottomSheet.this.dismiss();
                    return true;
                }
                this.startedTrackingPointerId = ev.getPointerId(0);
                this.maybeStartTracking = true;
                this.cancelCurrentAnimation();
                if (this.velocityTracker != null) {
                    this.velocityTracker.clear();
                }
            } else if (ev != null && ev.getAction() == 2 && ev.getPointerId(0) == this.startedTrackingPointerId) {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                }
                float dx = Math.abs((int)(ev.getX() - (float)this.startedTrackingX));
                float dy = (int)ev.getY() - this.startedTrackingY;
                this.velocityTracker.addMovement(ev);
                if (this.maybeStartTracking && !this.startedTracking && dy > 0.0f && dy / 3.0f > Math.abs(dx) && Math.abs(dy) >= (float)BottomSheet.this.touchSlop) {
                    this.startedTrackingY = (int)ev.getY();
                    this.maybeStartTracking = false;
                    this.startedTracking = true;
                    this.requestDisallowInterceptTouchEvent(true);
                } else if (this.startedTracking) {
                    float translationY = BottomSheet.this.containerView.getTranslationY();
                    if ((translationY += dy) < 0.0f) {
                        translationY = 0.0f;
                    }
                    BottomSheet.this.containerView.setTranslationY(translationY);
                    this.startedTrackingY = (int)ev.getY();
                }
            } else if (ev == null || ev.getPointerId(0) == this.startedTrackingPointerId && (ev.getAction() == 3 || ev.getAction() == 1 || ev.getAction() == 6)) {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                }
                this.velocityTracker.computeCurrentVelocity(1000);
                float translationY = BottomSheet.this.containerView.getTranslationY();
                if (this.startedTracking || translationY != 0.0f) {
                    this.checkDismiss(this.velocityTracker.getXVelocity(), this.velocityTracker.getYVelocity());
                    this.startedTracking = false;
                } else {
                    this.maybeStartTracking = false;
                    this.startedTracking = false;
                }
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
                this.startedTrackingPointerId = -1;
            }
            return this.startedTracking || !BottomSheet.this.canDismissWithSwipe();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int height;
            boolean isPortrait;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            boolean bl = isPortrait = width < (height = View.MeasureSpec.getSize((int)heightMeasureSpec));
            if (BottomSheet.this.lastInsets != null && Build.VERSION.SDK_INT >= 21) {
                width -= BottomSheet.this.lastInsets.getSystemWindowInsetRight() + BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                height -= BottomSheet.this.lastInsets.getSystemWindowInsetBottom();
            }
            this.setMeasuredDimension(width, height);
            if (BottomSheet.this.containerView != null) {
                if (BottomSheet.this.fullWidth) {
                    BottomSheet.this.containerView.measure(View.MeasureSpec.makeMeasureSpec((int)(width + backgroundPaddingLeft * 2), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
                } else {
                    int widthSpec = Utils.isTablet(this.getContext()) ? View.MeasureSpec.makeMeasureSpec((int)((int)((float)Math.min(((BottomSheet)BottomSheet.this).displaySize.x, ((BottomSheet)BottomSheet.this).displaySize.y) * 0.8f) + backgroundPaddingLeft * 2), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(isPortrait ? width + backgroundPaddingLeft * 2 : (int)Math.max((float)width * 0.8f, (float)Math.min(Utils.dp(this.getContext(), 480.0f), width)) + backgroundPaddingLeft * 2), (int)0x40000000);
                    BottomSheet.this.containerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
                }
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == BottomSheet.this.containerView) continue;
                this.measureChildWithMargins(child, View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000), 0);
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            BottomSheet.this.layoutCount--;
            if (BottomSheet.this.containerView != null) {
                int t = bottom - top - BottomSheet.this.containerView.getMeasuredHeight();
                if (BottomSheet.this.lastInsets != null && Build.VERSION.SDK_INT >= 21) {
                    left += BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                    right += BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                }
                int l = (right - left - BottomSheet.this.containerView.getMeasuredWidth()) / 2;
                BottomSheet.this.containerView.layout(l, t, l + BottomSheet.this.containerView.getMeasuredWidth(), t + BottomSheet.this.containerView.getMeasuredHeight());
            }
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                int childTop;
                int childLeft;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == BottomSheet.this.containerView) continue;
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
                int width = child.getMeasuredWidth();
                int height = child.getMeasuredHeight();
                int gravity = lp.gravity;
                if (gravity == -1) {
                    gravity = 0x800033;
                }
                int absoluteGravity = gravity & 7;
                int verticalGravity = gravity & 0x70;
                switch (absoluteGravity & 7) {
                    case 1: {
                        childLeft = (right - left - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    }
                    case 0x800005: {
                        childLeft = right - width - lp.rightMargin;
                        break;
                    }
                    default: {
                        childLeft = lp.leftMargin;
                    }
                }
                switch (verticalGravity) {
                    case 48: {
                        childTop = lp.topMargin;
                        break;
                    }
                    case 16: {
                        childTop = (bottom - top - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    }
                    case 80: {
                        childTop = bottom - top - height - lp.bottomMargin;
                        break;
                    }
                    default: {
                        childTop = lp.topMargin;
                    }
                }
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
            }
            if (BottomSheet.this.layoutCount == 0 && BottomSheet.this.startAnimationRunnable != null) {
                BottomSheet.this.handler.removeCallbacks(BottomSheet.this.startAnimationRunnable);
                BottomSheet.this.startAnimationRunnable.run();
                BottomSheet.this.startAnimationRunnable = null;
            }
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            if (BottomSheet.this.canDismissWithSwipe()) {
                return this.onTouchEvent(event);
            }
            return super.onInterceptTouchEvent(event);
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            if (this.maybeStartTracking && !this.startedTracking) {
                this.onTouchEvent(null);
            }
            super.requestDisallowInterceptTouchEvent(disallowIntercept);
        }

        public boolean hasOverlappingRendering() {
            return false;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Theme {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Type {
    }
}

