/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheetdialog;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.michaelbel.bottomsheetdialog.Utils;

public class BottomSheetGrid
extends LinearLayout {
    private TextView textView;
    private ImageView iconView;

    public BottomSheetGrid(Context context) {
        super(context);
        this.setOrientation(1);
        this.setPadding(Utils.dp(this.getContext(), 24.0f), Utils.dp(this.getContext(), 16.0f), Utils.dp(this.getContext(), 24.0f), Utils.dp(this.getContext(), 16.0f));
        this.iconView = new ImageView(context);
        this.iconView.setScaleType(ImageView.ScaleType.CENTER);
        LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams(Utils.dp(this.getContext(), 48.0f), Utils.dp(this.getContext(), 48.0f));
        params1.gravity = 49;
        this.iconView.setLayoutParams((ViewGroup.LayoutParams)params1);
        this.addView((View)this.iconView);
        this.textView = new TextView(context);
        this.textView.setLines(1);
        this.textView.setMaxLines(1);
        this.textView.setSingleLine(true);
        this.textView.setEllipsize(TextUtils.TruncateAt.END);
        this.textView.setTextSize(2, 16.0f);
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -2);
        params2.gravity = 81;
        this.textView.setLayoutParams((ViewGroup.LayoutParams)params2);
        this.addView((View)this.textView);
    }

    public BottomSheetGrid setIcon(@DrawableRes int resId, @ColorInt int color) {
        Drawable icon = ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
        if (icon != null) {
            icon.clearColorFilter();
            icon.mutate().setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
        this.iconView.setImageDrawable(icon);
        return this;
    }

    public BottomSheetGrid setText(@NonNull CharSequence text, @ColorInt int color) {
        this.textView.setText(text);
        this.textView.setTextColor(color);
        return this;
    }
}

