/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.BoolRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import org.michaelbel.bottomsheet.BottomSheetCell;
import org.michaelbel.bottomsheet.BottomSheetGrid;
import org.michaelbel.bottomsheet.R;
import org.michaelbel.bottomsheet.Utils;

public class BottomSheet
extends Dialog {
    private static final String TAG = BottomSheet.class.getSimpleName();
    public static final int LIST = 1;
    public static final int GRID = 2;
    private boolean fullWidth;
    private boolean darkTheme;
    @ColorInt
    private int backgroundColor;
    @ColorInt
    private int titleTextColor;
    @ColorInt
    private int itemTextColor;
    @ColorInt
    private int iconColor;
    private int itemSelector;
    private View customView;
    private CharSequence titleText;
    private int contentType = 1;
    private CharSequence[] mItems;
    @StringRes
    private int[] mItemsRes;
    @DrawableRes
    private int[] mIcons;
    private ArrayList<Item> items = new ArrayList();
    private ViewGroup containerView;
    private ContainerView container;
    private WindowInsets lastInsets;
    private Runnable startAnimationRunnable;
    private int layoutCount;
    private boolean dismissed;
    private DialogInterface.OnClickListener onClickListener;
    private ColorDrawable backDrawable = new ColorDrawable(-16777216);
    private boolean allowCustomAnimation = true;
    private int touchSlop;
    private boolean useFastDismiss;
    private boolean focusable;
    private Drawable shadowDrawable;
    private static int backgroundPaddingTop;
    private static int backgroundPaddingLeft;
    private AnimatorSet currentSheetAnimation;
    private Point displaySize = new Point();
    private DisplayMetrics metrics = new DisplayMetrics();
    private Handler handler = new Handler(Looper.getMainLooper());
    private Callback bottomSheetCallBack;

    protected void onCreate(Bundle savedInstanceState) {
        Window window;
        super.onCreate(savedInstanceState);
        if (this.backgroundColor == 0) {
            int n = this.backgroundColor = this.darkTheme ? -12434878 : -1;
        }
        if (this.titleTextColor == 0) {
            int n = this.titleTextColor = this.darkTheme ? -1275068417 : -1979711488;
        }
        if (this.itemTextColor == 0) {
            int n = this.itemTextColor = this.darkTheme ? -1 : -570425344;
        }
        if (this.iconColor == 0) {
            int n = this.iconColor = this.darkTheme ? -1 : -1979711488;
        }
        if (this.itemSelector == 0) {
            int n = this.itemSelector = this.darkTheme ? R.drawable.selectable_dark : R.drawable.selectable_light;
        }
        if ((window = this.getWindow()) != null) {
            window.setWindowAnimations(R.style.DialogNoAnimation);
        }
        this.setContentView((View)this.container, new ViewGroup.LayoutParams(-1, -1));
        if (this.containerView == null) {
            this.containerView = new FrameLayout(this.getContext()){

                public boolean hasOverlappingRendering() {
                    return false;
                }
            };
            if (Build.VERSION.SDK_INT >= 16) {
                this.containerView.setBackground(this.shadowDrawable);
            } else {
                this.containerView.setBackgroundDrawable(this.shadowDrawable);
            }
            this.containerView.setPadding(0, backgroundPaddingTop, 0, Utils.dp(this.getContext(), 8.0f));
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.containerView.setFitsSystemWindows(true);
        }
        this.containerView.setVisibility(4);
        this.containerView.setBackgroundColor(this.backgroundColor);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        this.containerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.container.addView((View)this.containerView, 0);
        if (this.customView != null) {
            if (this.customView.getParent() != null) {
                ViewGroup viewGroup = (ViewGroup)this.customView.getParent();
                viewGroup.removeView(this.customView);
            }
            FrameLayout.LayoutParams params1 = (FrameLayout.LayoutParams)this.containerView.getLayoutParams();
            params1.width = -1;
            params1.height = -2;
            params1.gravity = 0x800033;
            this.containerView.addView(this.customView, (ViewGroup.LayoutParams)params1);
        } else {
            int topOffset = 0;
            if (this.titleText != null) {
                TextView titleTextView = new TextView(this.getContext());
                titleTextView.setLines(1);
                titleTextView.setMaxLines(1);
                titleTextView.setSingleLine(true);
                titleTextView.setText(this.titleText);
                titleTextView.setTextColor(this.titleTextColor);
                titleTextView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                titleTextView.setTextSize(1, 16.0f);
                titleTextView.setGravity(16);
                FrameLayout.LayoutParams params0 = new FrameLayout.LayoutParams(-2, Utils.dp(this.getContext(), 56.0f));
                params0.gravity = 0x800033;
                params0.leftMargin = Utils.dp(this.getContext(), 16.0f);
                params0.rightMargin = Utils.dp(this.getContext(), 16.0f);
                titleTextView.setLayoutParams((ViewGroup.LayoutParams)params0);
                this.containerView.addView((View)titleTextView);
                titleTextView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        return true;
                    }
                });
                topOffset += 56;
            }
            BottomSheetAdapter adapter = new BottomSheetAdapter();
            if (this.mItems != null || this.mItemsRes != null) {
                if (this.contentType == 1) {
                    FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-1, -2);
                    params2.topMargin = Utils.dp(this.getContext(), topOffset);
                    ListView listView = new ListView(this.getContext());
                    listView.setSelector(this.itemSelector);
                    listView.setDividerHeight(0);
                    listView.setAdapter((ListAdapter)adapter);
                    listView.setDrawSelectorOnTop(true);
                    listView.setVerticalScrollBarEnabled(false);
                    listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                            BottomSheet.this.dismissWithButtonClick(i);
                        }
                    });
                    listView.setLayoutParams((ViewGroup.LayoutParams)params2);
                    this.containerView.addView((View)listView);
                } else if (this.contentType == 2) {
                    FrameLayout.LayoutParams params3 = new FrameLayout.LayoutParams(-1, -2);
                    GridView gridView = new GridView(this.getContext());
                    gridView.setSelector(this.itemSelector);
                    gridView.setAdapter((ListAdapter)adapter);
                    gridView.setNumColumns(3);
                    gridView.setVerticalScrollBarEnabled(false);
                    gridView.setVerticalSpacing(Utils.dp(this.getContext(), 16.0f));
                    gridView.setPadding(Utils.dp(this.getContext(), 0.0f), Utils.dp(this.getContext(), topOffset + 8), Utils.dp(this.getContext(), 0.0f), Utils.dp(this.getContext(), 16.0f));
                    gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                            BottomSheet.this.dismissWithButtonClick(i);
                        }
                    });
                    gridView.setLayoutParams((ViewGroup.LayoutParams)params3);
                    this.containerView.addView((View)gridView);
                }
                if (this.mItems != null) {
                    for (int a = 0; a < this.mItems.length; ++a) {
                        this.items.add(new Item(this.mItems[a], this.mIcons != null ? this.mIcons[a] : 0));
                    }
                } else {
                    for (int a = 0; a < this.mItemsRes.length; ++a) {
                        this.items.add(new Item(this.getContext().getText(this.mItemsRes[a]), this.mIcons != null ? this.mIcons[a] : 0));
                    }
                }
                adapter.notifyDataSetChanged();
            }
        }
        WindowManager.LayoutParams params4 = window.getAttributes();
        params4.width = -1;
        params4.gravity = 0x800033;
        params4.dimAmount = 0.0f;
        params4.flags &= 0xFFFFFFFD;
        if (!this.focusable) {
            params4.flags |= 0x20000;
        }
        params4.height = -1;
        window.setAttributes(params4);
    }

    public void show() {
        super.show();
        if (this.focusable) {
            try {
                this.getWindow().setSoftInputMode(16);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
        this.dismissed = false;
        this.cancelSheetAnimation();
        if (this.containerView.getMeasuredHeight() == 0) {
            this.containerView.measure(View.MeasureSpec.makeMeasureSpec((int)this.displaySize.x, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.displaySize.y, (int)Integer.MIN_VALUE));
        }
        this.backDrawable.setAlpha(0);
        if (Build.VERSION.SDK_INT >= 18) {
            this.layoutCount = 2;
            this.startAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    if (BottomSheet.this.startAnimationRunnable != this) {
                        return;
                    }
                    BottomSheet.this.startAnimationRunnable = null;
                    BottomSheet.this.startOpenAnimation();
                }
            };
            this.handler.postDelayed(this.startAnimationRunnable, 150L);
        } else {
            this.startOpenAnimation();
        }
        if (this.bottomSheetCallBack != null) {
            this.bottomSheetCallBack.onOpen();
        }
    }

    public void dismiss() {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.cancelSheetAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getMeasuredHeight() + Utils.dp(this.getContext(), 10.0f)}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{0})});
        if (this.useFastDismiss) {
            int height = this.containerView.getMeasuredHeight();
            animatorSet.setDuration((long)Math.max(60, (int)(180.0f * ((float)height - this.containerView.getTranslationY()) / (float)height)));
            this.useFastDismiss = false;
        } else {
            animatorSet.setDuration(180L);
        }
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    BottomSheet.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BottomSheet.this.dismissInternal();
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)e.getMessage());
                            }
                        }
                    });
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
        if (this.bottomSheetCallBack != null) {
            this.bottomSheetCallBack.onClose();
        }
    }

    public BottomSheet(Context context, boolean needFocus) {
        super(context, R.style.TransparentDialog);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().addFlags(-2147417856);
        }
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
        Rect padding = new Rect();
        this.shadowDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.sheet_shadow);
        this.shadowDrawable.getPadding(padding);
        backgroundPaddingLeft = padding.left;
        backgroundPaddingTop = padding.top;
        this.container = new ContainerView(this.getContext());
        if (Build.VERSION.SDK_INT >= 16) {
            this.container.setBackground((Drawable)this.backDrawable);
        } else {
            this.container.setBackgroundDrawable((Drawable)this.backDrawable);
        }
        this.focusable = needFocus;
        if (Build.VERSION.SDK_INT >= 21) {
            this.container.setFitsSystemWindows(true);
            this.container.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                @SuppressLint(value={"NewApi"})
                public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                    BottomSheet.this.lastInsets = insets;
                    v.requestLayout();
                    return insets.consumeSystemWindowInsets();
                }
            });
            this.container.setSystemUiVisibility(1280);
        }
        this.backDrawable.setAlpha(0);
    }

    private boolean canDismissWithSwipe() {
        return true;
    }

    private void cancelSheetAnimation() {
        if (this.currentSheetAnimation != null) {
            this.currentSheetAnimation.cancel();
            this.currentSheetAnimation = null;
        }
    }

    private void startOpenAnimation() {
        this.containerView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 20) {
            this.container.setLayerType(2, null);
        }
        this.containerView.setTranslationY((float)this.containerView.getMeasuredHeight());
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{51})});
        animatorSet.setDuration(200L);
        animatorSet.setStartDelay(20L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    BottomSheet.this.container.setLayerType(0, null);
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
    }

    private void dismissWithButtonClick(final int viewId) {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.cancelSheetAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getMeasuredHeight() + Utils.dp(this.getContext(), 10.0f)}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{0})});
        animatorSet.setDuration(180L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    if (BottomSheet.this.onClickListener != null) {
                        BottomSheet.this.onClickListener.onClick((DialogInterface)BottomSheet.this, viewId);
                    }
                    BottomSheet.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BottomSheet.super.dismiss();
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)e.getMessage());
                            }
                        }
                    });
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
        if (this.bottomSheetCallBack != null) {
            this.bottomSheetCallBack.onClose();
        }
    }

    private void dismissInternal() {
        super.dismiss();
    }

    private float getPixelsInCM(float cm, boolean isX) {
        return cm / 2.54f * (isX ? this.metrics.xdpi : this.metrics.ydpi);
    }

    static /* synthetic */ CharSequence[] access$2402(BottomSheet x0, CharSequence[] x1) {
        x0.mItems = x1;
        return x1;
    }

    static /* synthetic */ int[] access$2702(BottomSheet x0, int[] x1) {
        x0.mItemsRes = x1;
        return x1;
    }

    static /* synthetic */ int[] access$2802(BottomSheet x0, int[] x1) {
        x0.mIcons = x1;
        return x1;
    }

    public static interface Callback {
        public void onOpen();

        public void onClose();
    }

    private class BottomSheetAdapter
    extends BaseAdapter {
        private BottomSheetAdapter() {
        }

        public int getCount() {
            return BottomSheet.this.items.size();
        }

        public Object getItem(int i) {
            return null;
        }

        public long getItemId(int i) {
            return 0L;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            int type = this.getItemViewType(i);
            Item item = (Item)BottomSheet.this.items.get(i);
            if (type == 0) {
                if (BottomSheet.this.contentType == 1) {
                    if (view == null) {
                        view = new BottomSheetCell(BottomSheet.this.getContext());
                    }
                    BottomSheetCell cell = (BottomSheetCell)((Object)view);
                    cell.setIcon(item.icon, BottomSheet.this.iconColor);
                    cell.setText(item.text, BottomSheet.this.itemTextColor);
                } else {
                    if (view == null) {
                        view = new BottomSheetGrid(BottomSheet.this.getContext());
                    }
                    BottomSheetGrid cell = (BottomSheetGrid)((Object)view);
                    cell.setIcon(item.icon, BottomSheet.this.iconColor);
                    cell.setText(item.text, BottomSheet.this.itemTextColor);
                }
            }
            return view;
        }

        public int getItemViewType(int i) {
            return 0;
        }

        public int getViewTypeCount() {
            return 1;
        }
    }

    public static class Builder {
        private Context context;
        private BottomSheet bottomSheet;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, false);
        }

        public Builder(@NonNull Context context, boolean focus) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, focus);
        }

        public Builder(@NonNull Context context, @BoolRes int needFocus) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, context.getResources().getBoolean(needFocus));
        }

        public Builder setItems(@NonNull CharSequence[] items, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$2402(this.bottomSheet, items);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setContentType(int type) {
            this.bottomSheet.contentType = type;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.bottomSheet.backgroundColor = color;
            return this;
        }

        public Builder setItems(@StringRes int[] items, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$2702(this.bottomSheet, items);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setItems(@NonNull CharSequence[] items, int[] icons, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$2402(this.bottomSheet, items);
            BottomSheet.access$2802(this.bottomSheet, icons);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setItems(@StringRes int[] items, int[] icons, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$2702(this.bottomSheet, items);
            BottomSheet.access$2802(this.bottomSheet, icons);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setCustomView(@NonNull View view) {
            this.bottomSheet.customView = view;
            return this;
        }

        public Builder setCustomView(@LayoutRes int layoutId) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
            this.setCustomView(layoutInflater.inflate(layoutId, null));
            return this;
        }

        public Builder setTitle(@NonNull CharSequence title) {
            this.bottomSheet.titleText = title;
            return this;
        }

        public Builder setTitle(@StringRes int stringId) {
            this.setTitle(this.context.getText(stringId));
            return this;
        }

        public Builder setTitleTextColor(@ColorInt int color) {
            this.bottomSheet.titleTextColor = color;
            return this;
        }

        public Builder setItemTextColor(@ColorInt int color) {
            this.bottomSheet.itemTextColor = color;
            return this;
        }

        public Builder setDarkTheme(boolean value) {
            this.bottomSheet.darkTheme = value;
            return this;
        }

        public Builder setIconColor(@ColorInt int color) {
            this.bottomSheet.iconColor = color;
            return this;
        }

        public Builder setFullWidth(boolean value) {
            this.bottomSheet.fullWidth = value;
            return this;
        }

        public Builder setItemSelector(int selector) {
            this.bottomSheet.itemSelector = selector;
            return this;
        }

        public Builder setCallback(@NonNull Callback callback) {
            this.bottomSheet.bottomSheetCallBack = callback;
            return this;
        }

        public BottomSheet show() {
            this.bottomSheet.show();
            return this.bottomSheet;
        }
    }

    private class ContainerView
    extends FrameLayout
    implements NestedScrollingParent {
        private int startedTrackingX;
        private int startedTrackingY;
        private int startedTrackingPointerId;
        private boolean maybeStartTracking;
        private boolean startedTracking;
        private AnimatorSet currentAnimation;
        private VelocityTracker velocityTracker;
        private NestedScrollingParentHelper nestedScrollingParentHelper;

        public ContainerView(Context context) {
            super(context);
            this.maybeStartTracking = false;
            this.startedTracking = false;
            this.currentAnimation = null;
            this.velocityTracker = null;
            this.nestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        }

        public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
            return !BottomSheet.this.dismissed && nestedScrollAxes == 2 && !BottomSheet.this.canDismissWithSwipe();
        }

        public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
            this.nestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
        }

        public void onStopNestedScroll(@NonNull View target) {
            this.nestedScrollingParentHelper.onStopNestedScroll(target);
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.checkDismiss(0.0f, 0.0f);
        }

        public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
            if (dyUnconsumed != 0) {
                float currentTranslation = BottomSheet.this.containerView.getTranslationY();
                if ((currentTranslation -= (float)dyUnconsumed) < 0.0f) {
                    currentTranslation = 0.0f;
                }
                BottomSheet.this.containerView.setTranslationY(currentTranslation);
            }
        }

        public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
            float currentTranslation = BottomSheet.this.containerView.getTranslationY();
            if (currentTranslation > 0.0f && dy > 0) {
                currentTranslation -= (float)dy;
                consumed[1] = dy;
                if (currentTranslation < 0.0f) {
                    currentTranslation = 0.0f;
                    consumed[1] = (int)((float)consumed[1] + currentTranslation);
                }
                BottomSheet.this.containerView.setTranslationY(currentTranslation);
            }
        }

        public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
            return false;
        }

        public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
            return false;
        }

        public int getNestedScrollAxes() {
            return this.nestedScrollingParentHelper.getNestedScrollAxes();
        }

        private void checkDismiss(float velX, float velY) {
            boolean backAnimation;
            float translationY = BottomSheet.this.containerView.getTranslationY();
            boolean bl = backAnimation = translationY < BottomSheet.this.getPixelsInCM(0.8f, false) && (velY < 3500.0f || Math.abs(velY) < Math.abs(velX)) || velY < 0.0f && Math.abs(velY) >= 3500.0f;
            if (!backAnimation) {
                boolean allowOld = BottomSheet.this.allowCustomAnimation;
                BottomSheet.this.allowCustomAnimation = false;
                BottomSheet.this.useFastDismiss = true;
                BottomSheet.this.dismiss();
                BottomSheet.this.allowCustomAnimation = allowOld;
            } else {
                this.currentAnimation = new AnimatorSet();
                this.currentAnimation.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)BottomSheet.this.containerView, (String)"translationY", (float[])new float[]{0.0f})});
                this.currentAnimation.setDuration((long)((int)(150.0f * (translationY / BottomSheet.this.getPixelsInCM(0.8f, false)))));
                this.currentAnimation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.currentAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (ContainerView.this.currentAnimation != null && ContainerView.this.currentAnimation.equals(animation)) {
                            ContainerView.this.currentAnimation = null;
                        }
                    }
                });
                this.currentAnimation.start();
            }
        }

        private void cancelCurrentAnimation() {
            if (this.currentAnimation != null) {
                this.currentAnimation.cancel();
                this.currentAnimation = null;
            }
        }

        public boolean onTouchEvent(MotionEvent ev) {
            if (BottomSheet.this.dismissed) {
                return false;
            }
            if (!(ev == null || ev.getAction() != 0 && ev.getAction() != 2 || this.startedTracking || this.maybeStartTracking)) {
                this.startedTrackingX = (int)ev.getX();
                this.startedTrackingY = (int)ev.getY();
                if (this.startedTrackingY < BottomSheet.this.containerView.getTop() || this.startedTrackingX < BottomSheet.this.containerView.getLeft() || this.startedTrackingX > BottomSheet.this.containerView.getRight()) {
                    BottomSheet.this.dismiss();
                    return true;
                }
                this.startedTrackingPointerId = ev.getPointerId(0);
                this.maybeStartTracking = true;
                this.cancelCurrentAnimation();
                if (this.velocityTracker != null) {
                    this.velocityTracker.clear();
                }
            } else if (ev != null && ev.getAction() == 2 && ev.getPointerId(0) == this.startedTrackingPointerId) {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                }
                float dx = Math.abs((int)(ev.getX() - (float)this.startedTrackingX));
                float dy = (int)ev.getY() - this.startedTrackingY;
                this.velocityTracker.addMovement(ev);
                if (this.maybeStartTracking && !this.startedTracking && dy > 0.0f && dy / 3.0f > Math.abs(dx) && Math.abs(dy) >= (float)BottomSheet.this.touchSlop) {
                    this.startedTrackingY = (int)ev.getY();
                    this.maybeStartTracking = false;
                    this.startedTracking = true;
                    this.requestDisallowInterceptTouchEvent(true);
                } else if (this.startedTracking) {
                    float translationY = BottomSheet.this.containerView.getTranslationY();
                    if ((translationY += dy) < 0.0f) {
                        translationY = 0.0f;
                    }
                    BottomSheet.this.containerView.setTranslationY(translationY);
                    this.startedTrackingY = (int)ev.getY();
                }
            } else if (ev == null || ev.getPointerId(0) == this.startedTrackingPointerId && (ev.getAction() == 3 || ev.getAction() == 1 || ev.getAction() == 6)) {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                }
                this.velocityTracker.computeCurrentVelocity(1000);
                float translationY = BottomSheet.this.containerView.getTranslationY();
                if (this.startedTracking || translationY != 0.0f) {
                    this.checkDismiss(this.velocityTracker.getXVelocity(), this.velocityTracker.getYVelocity());
                    this.startedTracking = false;
                } else {
                    this.maybeStartTracking = false;
                    this.startedTracking = false;
                }
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
            }
            return this.startedTracking;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int height;
            boolean isPortrait;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            boolean bl = isPortrait = width < (height = View.MeasureSpec.getSize((int)heightMeasureSpec));
            if (BottomSheet.this.lastInsets != null && Build.VERSION.SDK_INT >= 21) {
                width -= BottomSheet.this.lastInsets.getSystemWindowInsetRight() + BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                height -= BottomSheet.this.lastInsets.getSystemWindowInsetBottom();
            }
            this.setMeasuredDimension(width, height);
            if (BottomSheet.this.containerView != null) {
                if (BottomSheet.this.fullWidth) {
                    BottomSheet.this.containerView.measure(View.MeasureSpec.makeMeasureSpec((int)(width + backgroundPaddingLeft * 2), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
                } else {
                    int widthSpec = Utils.isTablet(this.getContext()) ? View.MeasureSpec.makeMeasureSpec((int)((int)((float)Math.min(((BottomSheet)BottomSheet.this).displaySize.x, ((BottomSheet)BottomSheet.this).displaySize.y) * 0.8f) + backgroundPaddingLeft * 2), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(isPortrait ? width + backgroundPaddingLeft * 2 : (int)Math.max((float)width * 0.8f, (float)Math.min(Utils.dp(this.getContext(), 480.0f), width)) + backgroundPaddingLeft * 2), (int)0x40000000);
                    BottomSheet.this.containerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
                }
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == BottomSheet.this.containerView) continue;
                this.measureChildWithMargins(child, View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000), 0);
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            BottomSheet.this.layoutCount--;
            if (BottomSheet.this.containerView != null) {
                int t = bottom - top - BottomSheet.this.containerView.getMeasuredHeight();
                if (BottomSheet.this.lastInsets != null && Build.VERSION.SDK_INT >= 21) {
                    left += BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                    right += BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                }
                int l = (right - left - BottomSheet.this.containerView.getMeasuredWidth()) / 2;
                BottomSheet.this.containerView.layout(l, t, l + BottomSheet.this.containerView.getMeasuredWidth(), t + BottomSheet.this.containerView.getMeasuredHeight());
            }
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                int childTop;
                int childLeft;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == BottomSheet.this.containerView) continue;
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
                int width = child.getMeasuredWidth();
                int height = child.getMeasuredHeight();
                int gravity = lp.gravity;
                if (gravity == -1) {
                    gravity = 0x800033;
                }
                int absoluteGravity = gravity & 7;
                int verticalGravity = gravity & 0x70;
                switch (absoluteGravity & 7) {
                    case 1: {
                        childLeft = (right - left - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    }
                    case 0x800005: {
                        childLeft = right - width - lp.rightMargin;
                        break;
                    }
                    default: {
                        childLeft = lp.leftMargin;
                    }
                }
                switch (verticalGravity) {
                    case 48: {
                        childTop = lp.topMargin;
                        break;
                    }
                    case 16: {
                        childTop = (bottom - top - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    }
                    case 80: {
                        childTop = bottom - top - height - lp.bottomMargin;
                        break;
                    }
                    default: {
                        childTop = lp.topMargin;
                    }
                }
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
            }
            if (BottomSheet.this.layoutCount == 0 && BottomSheet.this.startAnimationRunnable != null) {
                BottomSheet.this.handler.removeCallbacks(BottomSheet.this.startAnimationRunnable);
                BottomSheet.this.startAnimationRunnable.run();
                BottomSheet.this.startAnimationRunnable = null;
            }
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            if (BottomSheet.this.canDismissWithSwipe()) {
                return this.onTouchEvent(event);
            }
            return super.onInterceptTouchEvent(event);
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            if (this.maybeStartTracking && !this.startedTracking) {
                this.onTouchEvent(null);
            }
            super.requestDisallowInterceptTouchEvent(disallowIntercept);
        }

        public boolean hasOverlappingRendering() {
            return false;
        }
    }

    private class Item {
        public int icon;
        public CharSequence text;

        public Item(CharSequence text, int icon) {
            this.text = text;
            this.icon = icon;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Type {
    }
}

