/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import org.michaelbel.bottomsheet.Utils;

public class BottomSheetCell
extends FrameLayout {
    private TextView textView;
    private ImageView iconView;

    public BottomSheetCell(Context context) {
        super(context);
        this.iconView = new ImageView(context);
        this.iconView.setScaleType(ImageView.ScaleType.CENTER);
        FrameLayout.LayoutParams params1 = new FrameLayout.LayoutParams(Utils.dp(context, 24.0f), Utils.dp(context, 24.0f));
        params1.gravity = 8388627;
        params1.leftMargin = Utils.dp(context, 16.0f);
        params1.rightMargin = Utils.dp(context, 16.0f);
        this.iconView.setLayoutParams((ViewGroup.LayoutParams)params1);
        this.addView((View)this.iconView);
        this.textView = new TextView(context);
        this.textView.setLines(1);
        this.textView.setMaxLines(1);
        this.textView.setSingleLine(true);
        this.textView.setEllipsize(TextUtils.TruncateAt.END);
        this.textView.setTextSize(1, 16.0f);
        FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
        params2.gravity = 8388627;
        params2.leftMargin = Utils.dp(context, 16.0f);
        params2.rightMargin = Utils.dp(context, 16.0f);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)params2);
        this.addView((View)this.textView);
    }

    public BottomSheetCell setIcon(@DrawableRes int resId, @ColorInt int color) {
        if (resId != 0) {
            Drawable res = ContextCompat.getDrawable((Context)this.getContext(), (int)resId);
            res.clearColorFilter();
            res.mutate().setColorFilter(color, PorterDuff.Mode.MULTIPLY);
            this.iconView.setImageDrawable(res);
            FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
            params2.gravity = 8388627;
            params2.leftMargin = Utils.dp(this.getContext(), 72.0f);
            params2.rightMargin = Utils.dp(this.getContext(), 16.0f);
            this.textView.setLayoutParams((ViewGroup.LayoutParams)params2);
        } else {
            FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-2, -2);
            params2.gravity = 8388627;
            params2.leftMargin = Utils.dp(this.getContext(), 16.0f);
            params2.rightMargin = Utils.dp(this.getContext(), 16.0f);
            this.textView.setLayoutParams((ViewGroup.LayoutParams)params2);
        }
        return this;
    }

    public BottomSheetCell setText(@NonNull CharSequence text, @ColorInt int color) {
        this.textView.setText(text);
        this.textView.setTextColor(color);
        return this;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.makeMeasureSpec((int)widthMeasureSpec, (int)0x40000000);
        int height = Utils.dp(this.getContext(), 48.0f);
        this.setMeasuredDimension(width, height);
    }
}

