package org.michaelbel.bottomsheet.test;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.widget.FrameLayout;

import org.michaelbel.bottomsheet.R;

class Utils {

    private static final String TAG = Utils.class.getSimpleName();

    static final int MATCH_PARENT = -1;
    static final int WRAP_CONTENT = -2;

    private static Boolean isTablet = null;

    static Point displaySize = new Point();
    private static volatile Handler applicationHandler;
    private static DisplayMetrics displayMetrics = new DisplayMetrics();

    static int dp(@NonNull Context context, float value) {
        return (int) Math.ceil(context.getResources().getDisplayMetrics().density * value);
    }

    public static boolean isTablet(@NonNull Context context) {
        if (isTablet == null) {
            //isTablet = context.getResources().getBoolean(R.bool.isTablet);
            isTablet = false;
        }

        return isTablet;
    }

    public static int selectableItemBackgroundBorderless(@NonNull Context context) {
        int[] attrs = new int[] {
                R.attr.selectableItemBackgroundBorderless
        };

        TypedArray typedArray = context.obtainStyledAttributes(attrs);
        int backgroundResource = typedArray.getResourceId(0, 0);
        typedArray.recycle();

        return backgroundResource;
    }

    static float getPixelsInCM(float cm, boolean isX) {
        return (cm / 2.54f) * (isX ? displayMetrics.xdpi : displayMetrics.ydpi);
    }

    static void runOnUIThread(Context context, Runnable runnable) {
        runOnUIThread(context, runnable, 0);
    }

    static void runOnUIThread(Context context, Runnable runnable, long delay) {
        applicationHandler = new Handler(context.getMainLooper());

        if (delay == 0) {
            applicationHandler.post(runnable);
        } else {
            applicationHandler.postDelayed(runnable, delay);
        }
    }

    static void cancelRunOnUIThread(Context context, Runnable runnable) {
        applicationHandler = new Handler(context.getMainLooper());
        applicationHandler.removeCallbacks(runnable);
    }

    private static int getSize(@NonNull Context context, float size) {
        return (int) (size < 0 ? size : Utils.dp(context, size));
    }

    static FrameLayout.LayoutParams makeFrame(Context context, int width, int height, int gravity) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(getSize(context, width), getSize(context, height));
        params.gravity = gravity;
        return params;
    }

    static FrameLayout.LayoutParams makeFrame(Context context, int width, int height, int gravity, float startMargin, float topMargin, float endMargin, float bottomMargin) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(getSize(context, width), getSize(context, height));
        params.gravity = gravity;
        params.leftMargin = getSize(context, startMargin);
        params.topMargin = getSize(context, topMargin);
        params.rightMargin = getSize(context, endMargin);
        params.bottomMargin = getSize(context, bottomMargin);
        return params;
    }
}