package org.michaelbel.bottomsheet.test;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import org.michaelbel.bottomsheet.R;

public class BottomSheetCell extends FrameLayout {

    private TextView textView;
    private ImageView iconView;

    public BottomSheetCell(Context context) {
        super(context);

        setBackground(ContextCompat.getDrawable(getContext(), R.drawable.list_selector));

        iconView = new ImageView(context);
        iconView.setScaleType(ImageView.ScaleType.CENTER);
        iconView.setLayoutParams(Utils.makeFrame(context, 24, 24, Gravity.START | Gravity.CENTER_VERTICAL, 16, 0, 16, 0));
        addView(iconView);

        textView = new TextView(context);
        textView.setLines(1);
        textView.setMaxLines(1);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);
        textView.setLayoutParams(Utils.makeFrame(context, Utils.WRAP_CONTENT,
                Utils.WRAP_CONTENT, Gravity.START | Gravity.CENTER_VERTICAL, 16, 0, 16, 0));
        addView(textView);
    }

    public BottomSheetCell setIcon(@DrawableRes int resId, @ColorInt int color) {
        if (resId != 0) {
            Drawable icon = ContextCompat.getDrawable(getContext(), resId);
            icon.clearColorFilter();
            icon.mutate().setColorFilter(color, PorterDuff.Mode.MULTIPLY);

            iconView.setImageDrawable(icon);
            textView.setLayoutParams(Utils.makeFrame(getContext(), Utils.WRAP_CONTENT,
                    Utils.WRAP_CONTENT, Gravity.START | Gravity.CENTER_VERTICAL, 72, 0, 16, 0));
        } else {
            textView.setLayoutParams(Utils.makeFrame(getContext(), Utils.WRAP_CONTENT,
                    Utils.WRAP_CONTENT, Gravity.START | Gravity.CENTER_VERTICAL, 16, 0, 16, 0));
        }

        return this;
    }

    public BottomSheetCell setText(@NonNull CharSequence text, @ColorInt int color) {
        textView.setText(text);
        textView.setTextColor(color);
        return this;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, MeasureSpec.makeMeasureSpec(Utils.dp(getContext(), 48), MeasureSpec.EXACTLY));
    }
}