/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.Log;
import android.widget.FrameLayout;
import java.util.Hashtable;
import org.michaelbel.bottomsheet.R;

public class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    private static Boolean isTablet = null;
    public static Point displaySize = new Point();
    public static volatile Handler applicationHandler;
    public static DisplayMetrics displayMetrics;
    private static final Hashtable<String, Typeface> typefaceCache;

    public static int dp(@NonNull Context context, float value) {
        return (int)Math.ceil(context.getResources().getDisplayMetrics().density * value);
    }

    public static boolean isTablet(@NonNull Context context) {
        if (isTablet == null) {
            isTablet = context.getResources().getBoolean(R.bool.isTablet);
        }
        return isTablet;
    }

    public static int selectableItemBackgroundBorderless(@NonNull Context context) {
        int[] attrs = new int[]{R.attr.selectableItemBackgroundBorderless};
        TypedArray typedArray = context.obtainStyledAttributes(attrs);
        int backgroundResource = typedArray.getResourceId(0, 0);
        typedArray.recycle();
        return backgroundResource;
    }

    public static Drawable selectableItemBackgroundDrawable(@NonNull Context context) {
        int[] attrs = new int[]{16843534};
        TypedArray ta = context.obtainStyledAttributes(attrs);
        Drawable drawableFromTheme = ta.getDrawable(0);
        ta.recycle();
        return drawableFromTheme;
    }

    public static float getPixelsInCM(float cm, boolean isX) {
        return cm / 2.54f * (isX ? Utils.displayMetrics.xdpi : Utils.displayMetrics.ydpi);
    }

    public static void runOnUIThread(Context context, Runnable runnable) {
        Utils.runOnUIThread(context, runnable, 0L);
    }

    public static void runOnUIThread(Context context, Runnable runnable, long delay) {
        applicationHandler = new Handler(context.getMainLooper());
        if (delay == 0L) {
            applicationHandler.post(runnable);
        } else {
            applicationHandler.postDelayed(runnable, delay);
        }
    }

    public static void cancelRunOnUIThread(Context context, Runnable runnable) {
        applicationHandler = new Handler(context.getMainLooper());
        applicationHandler.removeCallbacks(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface getTypeface(Context context, String assetPath) {
        Hashtable<String, Typeface> hashtable = typefaceCache;
        synchronized (hashtable) {
            if (!typefaceCache.containsKey(assetPath)) {
                try {
                    Typeface t = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)assetPath);
                    typefaceCache.put(assetPath, t);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getMessage());
                    return null;
                }
            }
            return typefaceCache.get(assetPath);
        }
    }

    private static int getSize(@NonNull Context context, float size) {
        return (int)(size < 0.0f ? size : (float)Utils.dp(context, size));
    }

    public static FrameLayout.LayoutParams makeFrame(Context context, int width, int height) {
        return new FrameLayout.LayoutParams(Utils.getSize(context, width), Utils.getSize(context, height));
    }

    public static FrameLayout.LayoutParams makeFrame(Context context, int width, int height, int gravity) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(Utils.getSize(context, width), Utils.getSize(context, height));
        params.gravity = gravity;
        return params;
    }

    public static FrameLayout.LayoutParams makeFrame(Context context, int width, int height, int gravity, float startMargin, float topMargin, float endMargin, float bottomMargin) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(Utils.getSize(context, width), Utils.getSize(context, height));
        params.gravity = gravity;
        params.leftMargin = Utils.getSize(context, startMargin);
        params.topMargin = Utils.getSize(context, topMargin);
        params.rightMargin = Utils.getSize(context, endMargin);
        params.bottomMargin = Utils.getSize(context, bottomMargin);
        return params;
    }

    static {
        displayMetrics = new DisplayMetrics();
        typefaceCache = new Hashtable();
    }
}

