/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import org.michaelbel.bottomsheet.Utils;

public class BottomSheetCell
extends FrameLayout {
    private TextView textView;
    private ImageView iconView;

    public BottomSheetCell(Context context) {
        super(context);
    }

    public BottomSheetCell(Context context, int type) {
        super(context);
        this.setForeground(Utils.selectableItemBackgroundDrawable(context));
        this.setPadding(Utils.dp(this.getContext(), 16.0f), 0, Utils.dp(this.getContext(), 16.0f), 0);
        if (type == 1) {
            this.iconView = new ImageView(context);
            this.iconView.setScaleType(ImageView.ScaleType.CENTER);
            this.addView((View)this.iconView, (ViewGroup.LayoutParams)Utils.makeFrame(context, 24, 24, 8388627));
            this.textView = new TextView(context);
            this.textView.setLines(1);
            this.textView.setMaxLines(1);
            this.textView.setSingleLine(true);
            this.textView.setEllipsize(TextUtils.TruncateAt.END);
            this.textView.setTextSize(1, 16.0f);
            this.addView((View)this.textView, (ViewGroup.LayoutParams)Utils.makeFrame(context, -2, -2, 8388627));
        } else if (type == 2) {
            // empty if block
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)Utils.dp(this.getContext(), 48.0f), (int)0x40000000));
    }

    public void setTextColor(int color) {
        this.textView.setTextColor(color);
    }

    public void setGravity(int gravity) {
        this.textView.setGravity(gravity);
    }

    public void setTextAndIcon(CharSequence text, int icon) {
        this.textView.setText(text);
        if (icon != 0) {
            this.iconView.setImageResource(icon);
            this.iconView.setVisibility(0);
            this.textView.setPadding(Utils.dp(this.getContext(), 56.0f), 0, 0, 0);
        } else {
            this.iconView.setVisibility(4);
            this.textView.setPadding(0, 0, 0, 0);
        }
    }

    public TextView getTextView() {
        return this.textView;
    }

    public ImageView getIconView() {
        return this.iconView;
    }
}

