/*
 * Decompiled with CFR 0.152.
 */
package org.michaelbel.bottomsheet;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.BoolRes;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import java.util.ArrayList;
import org.michaelbel.bottomsheet.AnimatorListenerAdapterProxy;
import org.michaelbel.bottomsheet.BottomSheetCell;
import org.michaelbel.bottomsheet.R;
import org.michaelbel.bottomsheet.Utils;

public class BottomSheet
extends Dialog {
    private static final String TAG = BottomSheet.class.getSimpleName();
    public static final int LIST = 1;
    public static final int GRID = 2;
    private static boolean isRTL = false;
    private boolean mFullWidth;
    private int contentType = 1;
    private CharSequence mTitleText;
    private CharSequence[] mItems;
    @StringRes
    private int[] mItemsRes;
    @DrawableRes
    private int[] mIcons;
    @ColorInt
    private int mTitleTextColor = -1979711488;
    @ColorInt
    private int mItemTextColor = -570425344;
    @ColorInt
    private int mBackgroundColor = -1;
    private View customView;
    @DrawableRes
    private Drawable[] mIconsRes;
    protected ViewGroup containerView;
    private ContainerView container;
    private WindowInsets lastInsets;
    private Runnable startAnimationRunnable;
    private int layoutCount;
    private boolean dismissed;
    private int tag;
    private DialogInterface.OnClickListener onClickListener;
    protected ColorDrawable backDrawable = new ColorDrawable(-16777216);
    private boolean allowCustomAnimation = true;
    private int touchSlop;
    private boolean useFastDismiss;
    private boolean focusable;
    protected Paint ciclePaint = new Paint(1);
    private Drawable shadowDrawable;
    protected static int backgroundPaddingTop;
    protected static int backgroundPaddingLeft;
    private boolean applyTopPadding = true;
    private boolean applyBottomPadding = true;
    private DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
    private AccelerateInterpolator accelerateInterpolator = new AccelerateInterpolator();
    private ArrayList<BottomSheetCell> itemViews = new ArrayList();
    private BottomSheetDelegateInterface delegate;
    protected AnimatorSet currentSheetAnimation;

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public BottomSheet(Context context, boolean needFocus) {
        super(context, R.style.TransparentDialog);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().addFlags(-2147417856);
        }
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
        Rect padding = new Rect();
        this.shadowDrawable = ContextCompat.getDrawable((Context)context, (int)R.drawable.sheet_shadow);
        this.shadowDrawable.getPadding(padding);
        backgroundPaddingLeft = padding.left;
        backgroundPaddingTop = padding.top;
        this.container = new ContainerView(this.getContext());
        this.container.setBackgroundDrawable((Drawable)this.backDrawable);
        this.focusable = needFocus;
        if (Build.VERSION.SDK_INT >= 21) {
            this.container.setFitsSystemWindows(true);
            this.container.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                @SuppressLint(value={"NewApi"})
                public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                    BottomSheet.this.lastInsets = insets;
                    v.requestLayout();
                    return insets.consumeSystemWindowInsets();
                }
            });
            this.container.setSystemUiVisibility(1280);
        }
        this.ciclePaint.setColor(-1);
        this.backDrawable.setAlpha(0);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        window.setWindowAnimations(R.style.DialogNoAnimation);
        this.setContentView((View)this.container, new ViewGroup.LayoutParams(-1, -1));
        if (this.containerView == null) {
            this.containerView = new FrameLayout(this.getContext()){

                public boolean hasOverlappingRendering() {
                    return false;
                }
            };
            this.containerView.setBackgroundDrawable(this.shadowDrawable);
            this.containerView.setPadding(backgroundPaddingLeft, (this.applyTopPadding ? Utils.dp(this.getContext(), 8.0f) : 0) + backgroundPaddingTop, backgroundPaddingLeft, this.applyBottomPadding ? Utils.dp(this.getContext(), 8.0f) : 0);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.containerView.setFitsSystemWindows(true);
        }
        this.containerView.setVisibility(4);
        this.container.addView((View)this.containerView, 0, (ViewGroup.LayoutParams)Utils.makeFrame(this.getContext(), -1, -2, 80));
        if (this.customView != null) {
            if (this.customView.getParent() != null) {
                ViewGroup viewGroup = (ViewGroup)this.customView.getParent();
                viewGroup.removeView(this.customView);
            }
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.containerView.getLayoutParams();
            params.width = -1;
            params.height = -2;
            params.gravity = 0x800033;
            this.containerView.addView(this.customView, (ViewGroup.LayoutParams)params);
        } else {
            int topOffset = 0;
            if (this.mTitleText != null) {
                TextView titleTextView = new TextView(this.getContext());
                titleTextView.setLines(1);
                titleTextView.setMaxLines(1);
                titleTextView.setSingleLine(true);
                titleTextView.setText(this.mTitleText);
                titleTextView.setTextColor(this.mTitleTextColor);
                titleTextView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                titleTextView.setTextSize(1, 16.0f);
                titleTextView.setPadding(Utils.dp(this.getContext(), 16.0f), 0, Utils.dp(this.getContext(), 16.0f), Utils.dp(this.getContext(), 8.0f));
                titleTextView.setGravity(16);
                this.containerView.addView((View)titleTextView, (ViewGroup.LayoutParams)Utils.makeFrame(this.getContext(), -1, 48));
                titleTextView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View v, MotionEvent event) {
                        return true;
                    }
                });
                topOffset += 48;
            }
            if (this.mItems != null || this.mItemsRes != null) {
                Object rowLayout = null;
                boolean lastRowLayoutNum = false;
                if (this.mItems != null) {
                    for (int a = 0; a < this.mItems.length; ++a) {
                        BottomSheetCell cell = new BottomSheetCell(this.getContext(), this.contentType);
                        cell.getTextView().setTextColor(this.mItemTextColor);
                        cell.setTextAndIcon(this.mItems[a], this.mIcons != null ? this.mIcons[a] : 0);
                        this.containerView.addView((View)cell, (ViewGroup.LayoutParams)Utils.makeFrame(this.getContext(), -1, 48, 51, 0.0f, topOffset, 0.0f, 0.0f));
                        topOffset += 48;
                        cell.setTag(a);
                        cell.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                BottomSheet.this.dismissWithButtonClick((Integer)v.getTag());
                            }
                        });
                        this.itemViews.add(cell);
                    }
                } else {
                    for (int a = 0; a < this.mItemsRes.length; ++a) {
                        BottomSheetCell cell = new BottomSheetCell(this.getContext(), this.contentType);
                        cell.getTextView().setTextColor(this.mItemTextColor);
                        cell.setTextAndIcon(this.getContext().getText(this.mItemsRes[a]), this.mIcons != null ? this.mIcons[a] : 0);
                        this.containerView.addView((View)cell, (ViewGroup.LayoutParams)Utils.makeFrame(this.getContext(), -1, 48, 51, 0.0f, topOffset, 0.0f, 0.0f));
                        topOffset += 48;
                        cell.setTag(a);
                        cell.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                BottomSheet.this.dismissWithButtonClick((Integer)v.getTag());
                            }
                        });
                        this.itemViews.add(cell);
                    }
                }
            }
        }
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.gravity = 51;
        params.dimAmount = 0.0f;
        params.flags &= 0xFFFFFFFD;
        if (!this.focusable) {
            params.flags |= 0x20000;
        }
        params.height = -1;
        window.setAttributes(params);
    }

    public void show() {
        super.show();
        if (this.focusable) {
            this.getWindow().setSoftInputMode(16);
        }
        this.dismissed = false;
        this.cancelSheetAnimation();
        if (this.containerView.getMeasuredHeight() == 0) {
            this.containerView.measure(View.MeasureSpec.makeMeasureSpec((int)Utils.displaySize.x, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)Utils.displaySize.y, (int)Integer.MIN_VALUE));
        }
        this.backDrawable.setAlpha(0);
        if (Build.VERSION.SDK_INT >= 18) {
            this.layoutCount = 2;
            this.startAnimationRunnable = new Runnable(){

                @Override
                public void run() {
                    if (BottomSheet.this.startAnimationRunnable != this) {
                        return;
                    }
                    BottomSheet.this.startAnimationRunnable = null;
                    BottomSheet.this.startOpenAnimation();
                }
            };
            Utils.runOnUIThread(this.getContext(), this.startAnimationRunnable, 150L);
        } else {
            this.startOpenAnimation();
        }
    }

    protected boolean canDismissWithSwipe() {
        return true;
    }

    public void setCustomView(View view) {
        this.customView = view;
    }

    public void setTitle(CharSequence value) {
        this.mTitleText = value;
    }

    public void setApplyTopPadding(boolean value) {
        this.applyTopPadding = value;
    }

    public void setApplyBottomPadding(boolean value) {
        this.applyBottomPadding = value;
    }

    private void cancelSheetAnimation() {
        if (this.currentSheetAnimation != null) {
            this.currentSheetAnimation.cancel();
            this.currentSheetAnimation = null;
        }
    }

    private void startOpenAnimation() {
        this.containerView.setVisibility(0);
        if (!this.onCustomOpenAnimation()) {
            if (Build.VERSION.SDK_INT >= 20) {
                this.container.setLayerType(2, null);
            }
            this.containerView.setTranslationY((float)this.containerView.getMeasuredHeight());
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{0.0f}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{51})});
            animatorSet.setDuration(200L);
            animatorSet.setStartDelay(20L);
            animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapterProxy(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                        BottomSheet.this.currentSheetAnimation = null;
                        if (BottomSheet.this.delegate != null) {
                            BottomSheet.this.delegate.onOpenAnimationEnd();
                        }
                        BottomSheet.this.container.setLayerType(0, null);
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                        BottomSheet.this.currentSheetAnimation = null;
                    }
                }
            });
            animatorSet.start();
            this.currentSheetAnimation = animatorSet;
        }
    }

    public void setDelegate(BottomSheetDelegateInterface bottomSheetDelegate) {
        this.delegate = bottomSheetDelegate;
    }

    public FrameLayout getContainer() {
        return this.container;
    }

    public ViewGroup getSheetContainer() {
        return this.containerView;
    }

    public int getTag() {
        return this.tag;
    }

    public void setItemText(int item, CharSequence text) {
        if (item < 0 || item >= this.itemViews.size()) {
            return;
        }
        BottomSheetCell cell = this.itemViews.get(item);
        cell.getTextView().setText(text);
    }

    public boolean isDismissed() {
        return this.dismissed;
    }

    public void dismissWithButtonClick(final int item) {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.cancelSheetAnimation();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getMeasuredHeight() + Utils.dp(this.getContext(), 10.0f)}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{0})});
        animatorSet.setDuration(180L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapterProxy(){

            @Override
            public void onAnimationEnd(Animator animation) {
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                    if (BottomSheet.this.onClickListener != null) {
                        BottomSheet.this.onClickListener.onClick((DialogInterface)BottomSheet.this, item);
                    }
                    Utils.runOnUIThread(BottomSheet.this.getContext(), new Runnable(){

                        @Override
                        public void run() {
                            try {
                                BottomSheet.super.dismiss();
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)e.getMessage());
                            }
                        }
                    });
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                    BottomSheet.this.currentSheetAnimation = null;
                }
            }
        });
        animatorSet.start();
        this.currentSheetAnimation = animatorSet;
    }

    public void dismiss() {
        if (this.dismissed) {
            return;
        }
        this.dismissed = true;
        this.cancelSheetAnimation();
        if (!this.allowCustomAnimation || !this.onCustomCloseAnimation()) {
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.containerView, (String)"translationY", (float[])new float[]{this.containerView.getMeasuredHeight() + Utils.dp(this.getContext(), 10.0f)}), ObjectAnimator.ofInt((Object)this.backDrawable, (String)"alpha", (int[])new int[]{0})});
            if (this.useFastDismiss) {
                int height = this.containerView.getMeasuredHeight();
                animatorSet.setDuration((long)Math.max(60, (int)(180.0f * ((float)height - this.containerView.getTranslationY()) / (float)height)));
                this.useFastDismiss = false;
            } else {
                animatorSet.setDuration(180L);
            }
            animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapterProxy(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                        BottomSheet.this.currentSheetAnimation = null;
                        Utils.runOnUIThread(BottomSheet.this.getContext(), new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    BottomSheet.this.dismissInternal();
                                }
                                catch (Exception e) {
                                    Log.e((String)TAG, (String)e.getMessage());
                                }
                            }
                        });
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    if (BottomSheet.this.currentSheetAnimation != null && BottomSheet.this.currentSheetAnimation.equals(animation)) {
                        BottomSheet.this.currentSheetAnimation = null;
                    }
                }
            });
            animatorSet.start();
            this.currentSheetAnimation = animatorSet;
        }
    }

    protected void dismissInternal() {
        super.dismiss();
    }

    protected boolean onCustomCloseAnimation() {
        return false;
    }

    protected boolean onCustomOpenAnimation() {
        return false;
    }

    static /* synthetic */ CharSequence[] access$1502(BottomSheet x0, CharSequence[] x1) {
        x0.mItems = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1802(BottomSheet x0, int[] x1) {
        x0.mItemsRes = x1;
        return x1;
    }

    static /* synthetic */ int[] access$1902(BottomSheet x0, int[] x1) {
        x0.mIcons = x1;
        return x1;
    }

    public static class Builder {
        private Context context;
        private BottomSheet bottomSheet;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, false);
        }

        public Builder(@NonNull Context context, boolean needFocus) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, needFocus);
        }

        public Builder(@NonNull Context context, @BoolRes int needFocus) {
            this.context = context;
            this.bottomSheet = new BottomSheet(context, context.getResources().getBoolean(needFocus));
        }

        public Builder setItems(@NonNull CharSequence[] items, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$1502(this.bottomSheet, items);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setType(@Type int type) {
            this.bottomSheet.contentType = type;
            return this;
        }

        public Builder setBackgroundColor(@ColorInt int color) {
            this.bottomSheet.mBackgroundColor = color;
            return this;
        }

        public Builder setItems(@StringRes int[] items, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$1802(this.bottomSheet, items);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setItems(@NonNull CharSequence[] items, int[] icons, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$1502(this.bottomSheet, items);
            BottomSheet.access$1902(this.bottomSheet, icons);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setItems(@StringRes int[] items, int[] icons, DialogInterface.OnClickListener onClickListener) {
            BottomSheet.access$1802(this.bottomSheet, items);
            BottomSheet.access$1902(this.bottomSheet, icons);
            this.bottomSheet.onClickListener = onClickListener;
            return this;
        }

        public Builder setCustomView(@NonNull View view) {
            this.bottomSheet.customView = view;
            return this;
        }

        public Builder setCustomView(@LayoutRes int layoutId) {
            LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
            this.setCustomView(layoutInflater.inflate(layoutId, null));
            return this;
        }

        public Builder setTitle(@NonNull CharSequence title) {
            this.bottomSheet.mTitleText = title;
            return this;
        }

        public Builder setTitle(@StringRes int stringId) {
            this.setTitle(this.context.getText(stringId));
            return this;
        }

        public Builder setTitleTextColor(@ColorInt int color) {
            this.bottomSheet.mTitleTextColor = color;
            return this;
        }

        public Builder setItemTextColor(@ColorInt int color) {
            this.bottomSheet.mItemTextColor = color;
            return this;
        }

        public BottomSheet create() {
            return this.bottomSheet;
        }

        public BottomSheet show() {
            this.bottomSheet.show();
            return this.bottomSheet;
        }

        public Builder setTag(int tag) {
            this.bottomSheet.tag = tag;
            return this;
        }

        public Builder setDelegate(BottomSheetDelegate delegate) {
            this.bottomSheet.setDelegate(delegate);
            return this;
        }

        public Builder setApplyTopPadding(boolean value) {
            this.bottomSheet.applyTopPadding = value;
            return this;
        }

        public Builder setApplyBottomPadding(boolean value) {
            this.bottomSheet.applyBottomPadding = value;
            return this;
        }

        public BottomSheet setFullWidth(boolean value) {
            this.bottomSheet.mFullWidth = value;
            return this.bottomSheet;
        }

        public BottomSheet setFullWidth(@BoolRes int boolId) {
            this.bottomSheet.mFullWidth = this.context.getResources().getBoolean(boolId);
            return this.bottomSheet;
        }
    }

    public static class BottomSheetDelegate
    implements BottomSheetDelegateInterface {
        @Override
        public void onOpenAnimationStart() {
        }

        @Override
        public void onOpenAnimationEnd() {
        }
    }

    public static interface BottomSheetDelegateInterface {
        public void onOpenAnimationStart();

        public void onOpenAnimationEnd();
    }

    private class ContainerView
    extends FrameLayout
    implements NestedScrollingParent {
        private VelocityTracker velocityTracker;
        private int startedTrackingX;
        private int startedTrackingY;
        private int startedTrackingPointerId;
        private boolean maybeStartTracking;
        private boolean startedTracking;
        private AnimatorSet currentAnimation;
        private NestedScrollingParentHelper nestedScrollingParentHelper;

        public ContainerView(Context context) {
            super(context);
            this.velocityTracker = null;
            this.maybeStartTracking = false;
            this.startedTracking = false;
            this.currentAnimation = null;
            this.nestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        }

        public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
            return !BottomSheet.this.dismissed && nestedScrollAxes == 2 && !BottomSheet.this.canDismissWithSwipe();
        }

        public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
            this.nestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
        }

        public void onStopNestedScroll(View target) {
            this.nestedScrollingParentHelper.onStopNestedScroll(target);
            if (BottomSheet.this.dismissed) {
                return;
            }
            float currentTranslation = BottomSheet.this.containerView.getTranslationY();
            this.checkDismiss(0.0f, 0.0f);
        }

        public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
            if (dyUnconsumed != 0) {
                float currentTranslation = BottomSheet.this.containerView.getTranslationY();
                if ((currentTranslation -= (float)dyUnconsumed) < 0.0f) {
                    currentTranslation = 0.0f;
                }
                BottomSheet.this.containerView.setTranslationY(currentTranslation);
            }
        }

        public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
            if (BottomSheet.this.dismissed) {
                return;
            }
            this.cancelCurrentAnimation();
            float currentTranslation = BottomSheet.this.containerView.getTranslationY();
            if (currentTranslation > 0.0f && dy > 0) {
                currentTranslation -= (float)dy;
                consumed[1] = dy;
                if (currentTranslation < 0.0f) {
                    currentTranslation = 0.0f;
                    consumed[1] = (int)((float)consumed[1] + currentTranslation);
                }
                BottomSheet.this.containerView.setTranslationY(currentTranslation);
            }
        }

        public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
            return false;
        }

        public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
            return false;
        }

        public int getNestedScrollAxes() {
            return this.nestedScrollingParentHelper.getNestedScrollAxes();
        }

        private void checkDismiss(float velX, float velY) {
            boolean backAnimation;
            float translationY = BottomSheet.this.containerView.getTranslationY();
            boolean bl = backAnimation = translationY < Utils.getPixelsInCM(0.8f, false) && (velY < 3500.0f || Math.abs(velY) < Math.abs(velX)) || velY < 0.0f && Math.abs(velY) >= 3500.0f;
            if (!backAnimation) {
                boolean allowOld = BottomSheet.this.allowCustomAnimation;
                BottomSheet.this.allowCustomAnimation = false;
                BottomSheet.this.useFastDismiss = true;
                BottomSheet.this.dismiss();
                BottomSheet.this.allowCustomAnimation = allowOld;
            } else {
                this.currentAnimation = new AnimatorSet();
                this.currentAnimation.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)BottomSheet.this.containerView, (String)"translationY", (float[])new float[]{0.0f})});
                this.currentAnimation.setDuration((long)((int)(150.0f * (translationY / Utils.getPixelsInCM(0.8f, false)))));
                this.currentAnimation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.currentAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapterProxy(){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (ContainerView.this.currentAnimation != null && ContainerView.this.currentAnimation.equals(animation)) {
                            ContainerView.this.currentAnimation = null;
                        }
                    }
                });
                this.currentAnimation.start();
            }
        }

        private void cancelCurrentAnimation() {
            if (this.currentAnimation != null) {
                this.currentAnimation.cancel();
                this.currentAnimation = null;
            }
        }

        public boolean onTouchEvent(MotionEvent ev) {
            if (BottomSheet.this.dismissed) {
                return false;
            }
            if (!(ev == null || ev.getAction() != 0 && ev.getAction() != 2 || this.startedTracking || this.maybeStartTracking)) {
                this.startedTrackingX = (int)ev.getX();
                this.startedTrackingY = (int)ev.getY();
                if (this.startedTrackingY < BottomSheet.this.containerView.getTop() || this.startedTrackingX < BottomSheet.this.containerView.getLeft() || this.startedTrackingX > BottomSheet.this.containerView.getRight()) {
                    BottomSheet.this.dismiss();
                    return true;
                }
                this.startedTrackingPointerId = ev.getPointerId(0);
                this.maybeStartTracking = true;
                this.cancelCurrentAnimation();
                if (this.velocityTracker != null) {
                    this.velocityTracker.clear();
                }
            } else if (ev != null && ev.getAction() == 2 && ev.getPointerId(0) == this.startedTrackingPointerId) {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                }
                float dx = Math.abs((int)(ev.getX() - (float)this.startedTrackingX));
                float dy = (int)ev.getY() - this.startedTrackingY;
                this.velocityTracker.addMovement(ev);
                if (this.maybeStartTracking && !this.startedTracking && dy > 0.0f && dy / 3.0f > Math.abs(dx) && Math.abs(dy) >= (float)BottomSheet.this.touchSlop) {
                    this.startedTrackingY = (int)ev.getY();
                    this.maybeStartTracking = false;
                    this.startedTracking = true;
                    this.requestDisallowInterceptTouchEvent(true);
                } else if (this.startedTracking) {
                    float translationY = BottomSheet.this.containerView.getTranslationY();
                    if ((translationY += dy) < 0.0f) {
                        translationY = 0.0f;
                    }
                    BottomSheet.this.containerView.setTranslationY(translationY);
                    this.startedTrackingY = (int)ev.getY();
                }
            } else if (ev == null || ev != null && ev.getPointerId(0) == this.startedTrackingPointerId && (ev.getAction() == 3 || ev.getAction() == 1 || ev.getAction() == 6)) {
                if (this.velocityTracker == null) {
                    this.velocityTracker = VelocityTracker.obtain();
                }
                this.velocityTracker.computeCurrentVelocity(1000);
                float translationY = BottomSheet.this.containerView.getTranslationY();
                if (this.startedTracking || translationY != 0.0f) {
                    this.checkDismiss(this.velocityTracker.getXVelocity(), this.velocityTracker.getYVelocity());
                    this.startedTracking = false;
                } else {
                    this.maybeStartTracking = false;
                    this.startedTracking = false;
                }
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
            }
            return this.startedTracking;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            boolean isPortrait;
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (BottomSheet.this.lastInsets != null && Build.VERSION.SDK_INT >= 21) {
                width -= BottomSheet.this.lastInsets.getSystemWindowInsetRight() + BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                height -= BottomSheet.this.lastInsets.getSystemWindowInsetBottom();
            }
            this.setMeasuredDimension(width, height);
            boolean bl = isPortrait = width < height;
            if (BottomSheet.this.containerView != null) {
                if (!BottomSheet.this.mFullWidth) {
                    int widthSpec = Utils.isTablet(this.getContext()) ? View.MeasureSpec.makeMeasureSpec((int)((int)((float)Math.min(Utils.displaySize.x, Utils.displaySize.y) * 0.8f) + backgroundPaddingLeft * 2), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)(isPortrait ? width + backgroundPaddingLeft * 2 : (int)Math.max((float)width * 0.8f, (float)Math.min(Utils.dp(this.getContext(), 480.0f), width)) + backgroundPaddingLeft * 2), (int)0x40000000);
                    BottomSheet.this.containerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
                } else {
                    BottomSheet.this.containerView.measure(View.MeasureSpec.makeMeasureSpec((int)(width + backgroundPaddingLeft * 2), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE));
                }
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == BottomSheet.this.containerView) continue;
                this.measureChildWithMargins(child, View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), 0, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000), 0);
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            BottomSheet.this.layoutCount--;
            if (BottomSheet.this.containerView != null) {
                int t = bottom - top - BottomSheet.this.containerView.getMeasuredHeight();
                if (BottomSheet.this.lastInsets != null && Build.VERSION.SDK_INT >= 21) {
                    left += BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                    right += BottomSheet.this.lastInsets.getSystemWindowInsetLeft();
                }
                int l = (right - left - BottomSheet.this.containerView.getMeasuredWidth()) / 2;
                BottomSheet.this.containerView.layout(l, t, l + BottomSheet.this.containerView.getMeasuredWidth(), t + BottomSheet.this.containerView.getMeasuredHeight());
            }
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                int childTop;
                int childLeft;
                View child = this.getChildAt(i);
                if (child.getVisibility() == 8 || child == BottomSheet.this.containerView) continue;
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
                int width = child.getMeasuredWidth();
                int height = child.getMeasuredHeight();
                int gravity = lp.gravity;
                if (gravity == -1) {
                    gravity = 51;
                }
                int absoluteGravity = gravity & 7;
                int verticalGravity = gravity & 0x70;
                switch (absoluteGravity & 7) {
                    case 1: {
                        childLeft = (right - left - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    }
                    case 5: {
                        childLeft = right - width - lp.rightMargin;
                        break;
                    }
                    default: {
                        childLeft = lp.leftMargin;
                    }
                }
                switch (verticalGravity) {
                    case 48: {
                        childTop = lp.topMargin;
                        break;
                    }
                    case 16: {
                        childTop = (bottom - top - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    }
                    case 80: {
                        childTop = bottom - top - height - lp.bottomMargin;
                        break;
                    }
                    default: {
                        childTop = lp.topMargin;
                    }
                }
                child.layout(childLeft, childTop, childLeft + width, childTop + height);
            }
            if (BottomSheet.this.layoutCount == 0 && BottomSheet.this.startAnimationRunnable != null) {
                Utils.cancelRunOnUIThread(this.getContext(), BottomSheet.this.startAnimationRunnable);
                BottomSheet.this.startAnimationRunnable.run();
                BottomSheet.this.startAnimationRunnable = null;
            }
        }

        public boolean onInterceptTouchEvent(MotionEvent event) {
            if (BottomSheet.this.canDismissWithSwipe()) {
                return this.onTouchEvent(event);
            }
            return super.onInterceptTouchEvent(event);
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            if (this.maybeStartTracking && !this.startedTracking) {
                this.onTouchEvent(null);
            }
            super.requestDisallowInterceptTouchEvent(disallowIntercept);
        }

        public boolean hasOverlappingRendering() {
            return false;
        }
    }

    public static @interface Type {
    }
}

