package org.michaelbel.bottomsheet;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.Log;
import android.widget.FrameLayout;

import java.util.Hashtable;

@SuppressWarnings({"unused"})
public class Utils {

    private static final String TAG = Utils.class.getSimpleName();

    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;

    private static Boolean isTablet = null;

    public static Point displaySize = new Point();
    public static volatile Handler applicationHandler;
    public static DisplayMetrics displayMetrics = new DisplayMetrics();
    private static final Hashtable<String, Typeface> typefaceCache = new Hashtable<>();

    public static int dp(@NonNull Context context, float value) {
        return (int) Math.ceil(context.getResources().getDisplayMetrics().density * value);
    }

    public static boolean isTablet(@NonNull Context context) {
        if (isTablet == null) {
            isTablet = context.getResources().getBoolean(R.bool.isTablet);
        }

        return isTablet;
    }

    public static int selectableItemBackgroundBorderless(@NonNull Context context) {
        int[] attrs = new int[] {
                R.attr.selectableItemBackgroundBorderless
        };

        TypedArray typedArray = context.obtainStyledAttributes(attrs);
        int backgroundResource = typedArray.getResourceId(0, 0);
        typedArray.recycle();

        return backgroundResource;
    }

    public static Drawable selectableItemBackgroundDrawable(@NonNull Context context) {
        int[] attrs = new int[] {
                android.R.attr.selectableItemBackground
        };

        TypedArray ta = context.obtainStyledAttributes(attrs);
        Drawable drawableFromTheme = ta.getDrawable(0);
        ta.recycle();

        return drawableFromTheme;
    }

    public static float getPixelsInCM(float cm, boolean isX) {
        return (cm / 2.54f) * (isX ? displayMetrics.xdpi : displayMetrics.ydpi);
    }

    public static void runOnUIThread(Context context, Runnable runnable) {
        runOnUIThread(context, runnable, 0);
    }

    public static void runOnUIThread(Context context, Runnable runnable, long delay) {
        applicationHandler = new Handler(context.getMainLooper());

        if (delay == 0) {
            applicationHandler.post(runnable);
        } else {
            applicationHandler.postDelayed(runnable, delay);
        }
    }

    public static void cancelRunOnUIThread(Context context, Runnable runnable) {
        applicationHandler = new Handler(context.getMainLooper());
        applicationHandler.removeCallbacks(runnable);
    }

    public static Typeface getTypeface(Context context, String assetPath) {
        synchronized (typefaceCache) {
            if (!typefaceCache.containsKey(assetPath)) {
                try {
                    Typeface t = Typeface.createFromAsset(context.getAssets(), assetPath);
                    typefaceCache.put(assetPath, t);
                } catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                    return null;
                }
            }
            return typefaceCache.get(assetPath);
        }
    }

    private static int getSize(@NonNull Context context, float size) {
        return (int) (size < 0 ? size : Utils.dp(context, size));
    }

    public static FrameLayout.LayoutParams makeFrame(Context context, int width, int height) {
        return new FrameLayout.LayoutParams(getSize(context, width), getSize(context, height));
    }

    public static FrameLayout.LayoutParams makeFrame(Context context, int width, int height, int gravity) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(getSize(context, width), getSize(context, height));
        params.gravity = gravity;
        return params;
    }

    public static FrameLayout.LayoutParams makeFrame(Context context, int width, int height, int gravity, float startMargin, float topMargin, float endMargin, float bottomMargin) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(getSize(context, width), getSize(context, height));
        params.gravity = gravity;
        params.leftMargin = getSize(context, startMargin);
        params.topMargin = getSize(context, topMargin);
        params.rightMargin = getSize(context, endMargin);
        params.bottomMargin = getSize(context, bottomMargin);
        return params;
    }
}