package org.michaelbel.bottomsheet;

import android.content.Context;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.Gravity;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

public class BottomSheetCell extends FrameLayout {

    private TextView textView;
    private ImageView iconView;

    public BottomSheetCell(Context context) {
        super(context);
    }

    public BottomSheetCell(Context context, int type) {
        super(context);

        //setBackgroundResource(R.drawable.list_selector);
        this.setForeground(Utils.selectableItemBackgroundDrawable(context));
        this.setPadding(Utils.dp(getContext(), 16), 0, Utils.dp(getContext(), 16), 0);

        if (type == 1) {
            iconView = new ImageView(context);
            iconView.setScaleType(ImageView.ScaleType.CENTER);

            //FrameLayout.LayoutParams params1 = (FrameLayout.LayoutParams) this.getLayoutParams();
            //params1.width = Utils.dp(context, 24);
            //params1.height = Utils.dp(context, 24);
            //params1.gravity = Gravity.START | Gravity.CENTER_VERTICAL;

            addView(iconView, Utils.makeFrame(context, 24, 24, Gravity.START | Gravity.CENTER_VERTICAL));

            textView = new TextView(context);
            textView.setLines(1);
            textView.setMaxLines(1);
            textView.setSingleLine(true);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            textView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 16);

            //FrameLayout.LayoutParams params2 = (FrameLayout.LayoutParams) this.getLayoutParams();
            //params2.width = ViewGroup.LayoutParams.WRAP_CONTENT;
            //params2.height = ViewGroup.LayoutParams.WRAP_CONTENT;
            //params2.gravity = Gravity.START | Gravity.CENTER_VERTICAL;

            addView(textView, Utils.makeFrame(context, Utils.WRAP_CONTENT, Utils.WRAP_CONTENT, Gravity.START | Gravity.CENTER_VERTICAL));
        } else if (type == 2) {

        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, MeasureSpec.makeMeasureSpec(Utils.dp(getContext(), 48), MeasureSpec.EXACTLY));
    }

    public void setTextColor(int color) {
        textView.setTextColor(color);
    }

    public void setGravity(int gravity) {
        textView.setGravity(gravity);
    }

    public void setTextAndIcon(CharSequence text, int icon) {
        textView.setText(text);

        if (icon != 0) {
            iconView.setImageResource(icon);
            iconView.setVisibility(VISIBLE);
            textView.setPadding(Utils.dp(getContext(), 56), 0, 0, 0);
        } else {
            iconView.setVisibility(INVISIBLE);
            textView.setPadding(0, 0, 0, 0);
        }
    }

    public TextView getTextView() {
        return textView;
    }

    public ImageView getIconView() {
        return iconView;
    }
}