/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.impl;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.Statement;
import org.mariadb.jdbc.client.Client;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.impl.MultiPrimaryClient;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class MultiPrimaryReplicaClient
extends MultiPrimaryClient {
    private static final Logger logger = Loggers.getLogger(MultiPrimaryReplicaClient.class);
    protected long waitTimeout;
    private Client replicaClient;
    private Client primaryClient = this.currentClient;
    private boolean requestReadOnly;
    private long nextTryReplica = -1L;
    private long nextTryPrimary = -1L;

    public MultiPrimaryReplicaClient(Configuration conf, ReentrantLock lock) throws SQLException {
        super(conf, lock);
        this.waitTimeout = Long.parseLong(conf.nonMappedOptions().getProperty("waitReconnectTimeout", "30000"));
        try {
            this.replicaClient = this.connectHost(true, false);
        }
        catch (SQLException e) {
            this.replicaClient = null;
            this.nextTryReplica = System.currentTimeMillis() + this.waitTimeout;
        }
    }

    private void reconnectIfNeeded() {
        if (!this.closed) {
            if (this.primaryClient == null && this.nextTryPrimary < System.currentTimeMillis()) {
                try {
                    this.primaryClient = this.connectHost(false, true);
                    this.nextTryPrimary = -1L;
                }
                catch (SQLException e) {
                    this.nextTryPrimary = System.currentTimeMillis() + this.waitTimeout;
                }
            }
            if (this.replicaClient == null && this.nextTryReplica < System.currentTimeMillis()) {
                try {
                    this.replicaClient = this.connectHost(true, true);
                    this.nextTryReplica = -1L;
                    if (this.requestReadOnly) {
                        this.syncNewState(this.primaryClient);
                        this.currentClient = this.replicaClient;
                    }
                }
                catch (SQLException e) {
                    this.nextTryReplica = System.currentTimeMillis() + this.waitTimeout;
                }
            }
        }
    }

    @Override
    protected void reConnect() throws SQLException {
        denyList.putIfAbsent(this.currentClient.getHostAddress(), System.currentTimeMillis() + this.deniedListTimeout);
        logger.info("Connection error on {}", this.currentClient.getHostAddress());
        try {
            Client oldClient = this.currentClient;
            if (oldClient.isPrimary()) {
                this.primaryClient = null;
            } else {
                this.replicaClient = null;
            }
            oldClient.getContext().resetPrepareCache();
            try {
                this.currentClient = this.connectHost(this.requestReadOnly, this.requestReadOnly);
                if (this.requestReadOnly) {
                    this.nextTryReplica = -1L;
                    this.replicaClient = this.currentClient;
                } else {
                    this.nextTryPrimary = -1L;
                    this.primaryClient = this.currentClient;
                }
            }
            catch (SQLNonTransientConnectionException e) {
                if (this.requestReadOnly) {
                    this.nextTryReplica = System.currentTimeMillis() + this.waitTimeout;
                    if (this.primaryClient != null) {
                        this.currentClient = this.primaryClient;
                    }
                    try {
                        this.currentClient = this.primaryClient = this.connectHost(false, false);
                        this.nextTryPrimary = -1L;
                    }
                    catch (SQLNonTransientConnectionException ee) {
                        this.closed = true;
                        throw new SQLNonTransientConnectionException(String.format("Driver has failed to reconnect connection after a communications failure with %s", oldClient.getHostAddress()), "08000");
                    }
                }
                throw new SQLNonTransientConnectionException(String.format("Driver has failed to reconnect master connection after a communications failure with %s", oldClient.getHostAddress()), "08000");
            }
            this.syncNewState(oldClient);
            if (!this.requestReadOnly) {
                if (this.conf.transactionReplay()) {
                    this.executeTransactionReplay(oldClient);
                } else if ((oldClient.getContext().getServerStatus() & 1) > 0) {
                    throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s. In progress transaction was lost", oldClient.getHostAddress()), "25S03");
                }
            }
        }
        catch (SQLNonTransientConnectionException sqle) {
            this.currentClient = null;
            this.closed = true;
            if (this.replicaClient != null) {
                this.replicaClient.close();
            }
            throw sqle;
        }
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.reconnectIfNeeded();
        return super.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.reconnectIfNeeded();
        return super.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        this.reconnectIfNeeded();
        super.readStreamingResults(completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        this.reconnectIfNeeded();
        super.closePrepare(prepare);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.reconnectIfNeeded();
        super.abort(executor);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.primaryClient != null) {
                    this.primaryClient.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (this.replicaClient != null) {
                    this.replicaClient.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.primaryClient = null;
            this.replicaClient = null;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        if (readOnly) {
            if (!this.requestReadOnly) {
                if (this.replicaClient != null) {
                    this.currentClient = this.replicaClient;
                    this.syncNewState(this.primaryClient);
                } else if (this.nextTryReplica < System.currentTimeMillis()) {
                    try {
                        this.currentClient = this.replicaClient = this.connectHost(true, true);
                        this.syncNewState(this.primaryClient);
                    }
                    catch (SQLException e) {
                        this.nextTryReplica = System.currentTimeMillis() + this.waitTimeout;
                    }
                }
            }
        } else if (this.requestReadOnly) {
            if (this.primaryClient != null) {
                this.currentClient = this.primaryClient;
                this.syncNewState(this.replicaClient);
            } else if (this.nextTryPrimary < System.currentTimeMillis()) {
                try {
                    this.primaryClient = this.connectHost(false, false);
                    this.nextTryPrimary = -1L;
                    this.syncNewState(this.replicaClient);
                }
                catch (SQLException e) {
                    this.nextTryPrimary = System.currentTimeMillis() + this.waitTimeout;
                    throw new SQLNonTransientConnectionException("Driver has failed to reconnect a primary connection", "08000");
                }
            }
        }
        this.requestReadOnly = readOnly;
    }

    @Override
    public int getSocketTimeout() {
        this.reconnectIfNeeded();
        return super.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        this.reconnectIfNeeded();
        super.setSocketTimeout(milliseconds);
    }

    @Override
    public Context getContext() {
        this.reconnectIfNeeded();
        return super.getContext();
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        this.reconnectIfNeeded();
        return super.getExceptionFactory();
    }

    @Override
    public HostAddress getHostAddress() {
        this.reconnectIfNeeded();
        return super.getHostAddress();
    }

    @Override
    public boolean isPrimary() {
        return this.getHostAddress().primary;
    }

    @Override
    public void reset() {
        if (this.replicaClient != null) {
            this.replicaClient.getContext().resetStateFlag();
            this.replicaClient.getContext().resetPrepareCache();
        }
        if (this.primaryClient != null) {
            this.primaryClient.getContext().resetStateFlag();
            this.primaryClient.getContext().resetPrepareCache();
        }
    }
}

