/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.message.client.ClientMessage;
import org.mariadb.jdbc.plugin.Credential;
import org.mariadb.jdbc.plugin.authentication.standard.NativePasswordPlugin;
import org.mariadb.jdbc.util.VersionFactory;

public final class HandshakeResponse
implements ClientMessage {
    private static final String _CLIENT_NAME = "_client_name";
    private static final String _CLIENT_VERSION = "_client_version";
    private static final String _SERVER_HOST = "_server_host";
    private static final String _OS = "_os";
    private static final String _THREAD = "_thread";
    private static final String _JAVA_VENDOR = "_java_vendor";
    private static final String _JAVA_VERSION = "_java_version";
    private final String username;
    private final CharSequence password;
    private final String database;
    private final String connectionAttributes;
    private final String host;
    private final long clientCapabilities;
    private final byte exchangeCharset;
    private final byte[] seed;
    private String authenticationPluginType;

    public HandshakeResponse(Credential credential, String authenticationPluginType, byte[] seed, Configuration conf, String host, long clientCapabilities, byte exchangeCharset) {
        this.authenticationPluginType = authenticationPluginType;
        this.seed = seed;
        this.username = credential.getUser();
        this.password = credential.getPassword();
        this.database = conf.database();
        this.connectionAttributes = conf.connectionAttributes();
        this.host = host;
        this.clientCapabilities = clientCapabilities;
        this.exchangeCharset = exchangeCharset;
    }

    private static void writeStringLengthAscii(PacketWriter encoder, String value) throws IOException {
        byte[] valBytes = value.getBytes(StandardCharsets.US_ASCII);
        encoder.writeLength(valBytes.length);
        encoder.writeBytes(valBytes);
    }

    private static void writeStringLength(PacketWriter encoder, String value) throws IOException {
        byte[] valBytes = value.getBytes(StandardCharsets.UTF_8);
        encoder.writeLength(valBytes.length);
        encoder.writeBytes(valBytes);
    }

    private static void writeConnectAttributes(PacketWriter writer, String connectionAttributes, String host) throws IOException {
        writer.mark();
        writer.writeInt(0);
        HandshakeResponse.writeStringLengthAscii(writer, _CLIENT_NAME);
        HandshakeResponse.writeStringLength(writer, "MariaDB Connector/J");
        HandshakeResponse.writeStringLengthAscii(writer, _CLIENT_VERSION);
        HandshakeResponse.writeStringLength(writer, VersionFactory.getInstance().getVersion());
        HandshakeResponse.writeStringLengthAscii(writer, _SERVER_HOST);
        HandshakeResponse.writeStringLength(writer, host != null ? host : "");
        HandshakeResponse.writeStringLengthAscii(writer, _OS);
        HandshakeResponse.writeStringLength(writer, System.getProperty("os.name"));
        HandshakeResponse.writeStringLengthAscii(writer, _THREAD);
        HandshakeResponse.writeStringLength(writer, Long.toString(Thread.currentThread().getId()));
        HandshakeResponse.writeStringLengthAscii(writer, _JAVA_VENDOR);
        HandshakeResponse.writeStringLength(writer, System.getProperty("java.vendor"));
        HandshakeResponse.writeStringLengthAscii(writer, _JAVA_VERSION);
        HandshakeResponse.writeStringLength(writer, System.getProperty("java.version"));
        if (connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    HandshakeResponse.writeStringLength(writer, token.substring(0, separator));
                    HandshakeResponse.writeStringLength(writer, token.substring(separator + 1));
                    continue;
                }
                HandshakeResponse.writeStringLength(writer, token);
                HandshakeResponse.writeStringLength(writer, "");
            }
        }
        int ending = writer.pos();
        writer.resetMark();
        int length = ending - (writer.pos() + 4);
        byte[] arr = new byte[]{-3, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16)};
        writer.writeBytes(arr);
        writer.pos(ending);
    }

    @Override
    public int encode(PacketWriter writer, Context context) throws IOException {
        byte[] authData;
        if ("mysql_clear_password".equals(this.authenticationPluginType)) {
            if ((this.clientCapabilities & 0x800L) == 0L) {
                throw new IllegalStateException("Cannot send password in clear if SSL is not enabled.");
            }
            authData = this.password == null ? new byte[]{} : this.password.toString().getBytes(StandardCharsets.UTF_8);
        } else {
            this.authenticationPluginType = "mysql_native_password";
            authData = NativePasswordPlugin.encryptPassword(this.password, this.seed);
        }
        writer.writeInt((int)this.clientCapabilities);
        writer.writeInt(0x40000000);
        writer.writeByte(this.exchangeCharset);
        writer.writeBytes(new byte[19]);
        writer.writeInt((int)(this.clientCapabilities >> 32));
        writer.writeString(this.username != null ? this.username : System.getProperty("user.name"));
        writer.writeByte(0);
        if ((context.getServerCapabilities() & 0x200000L) != 0L) {
            writer.writeLength(authData.length);
            writer.writeBytes(authData);
        } else if ((context.getServerCapabilities() & 0x8000L) != 0L) {
            writer.writeByte((byte)authData.length);
            writer.writeBytes(authData);
        } else {
            writer.writeBytes(authData);
            writer.writeByte(0);
        }
        if ((this.clientCapabilities & 8L) != 0L) {
            writer.writeString(this.database);
            writer.writeByte(0);
        }
        if ((context.getServerCapabilities() & 0x80000L) != 0L) {
            writer.writeString(this.authenticationPluginType);
            writer.writeByte(0);
        }
        if ((context.getServerCapabilities() & 0x100000L) != 0L) {
            HandshakeResponse.writeConnectAttributes(writer, this.connectionAttributes, this.host);
        }
        writer.flush();
        return 1;
    }
}

