/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec.list;

import java.io.IOException;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.TimeZone;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.DataType;
import org.mariadb.jdbc.codec.list.LocalDateTimeCodec;
import org.mariadb.jdbc.codec.list.LocalTimeCodec;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.Codec;

public class TimestampCodec
implements Codec<Timestamp> {
    public static final TimestampCodec INSTANCE = new TimestampCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATE, new DataType[]{DataType.NEWDATE, DataType.DATETIME, DataType.TIMESTAMP, DataType.YEAR, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.TIME, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Timestamp.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(Timestamp.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar calParam) throws SQLDataException {
        switch (column.getType()) {
            case TIME: {
                Timestamp t;
                Calendar cal;
                int[] parts = LocalTimeCodec.parseTime(buf, length, column);
                Calendar calendar = cal = calParam == null ? Calendar.getInstance() : calParam;
                synchronized (calendar) {
                    cal.clear();
                    cal.setLenient(true);
                    if (parts[0] == -1) {
                        cal.set(1970, 0, 1, parts[0] * parts[1], parts[0] * parts[2], parts[0] * parts[3] - 1);
                        t = new Timestamp(cal.getTimeInMillis());
                        t.setNanos(1000000000 - parts[4]);
                    } else {
                        cal.set(1970, 0, 1, parts[1], parts[2], parts[3]);
                        t = new Timestamp(cal.getTimeInMillis());
                        t.setNanos(parts[4]);
                    }
                }
                return t;
            }
            case YEAR: {
                Calendar cal1 = calParam == null ? Calendar.getInstance() : calParam;
                int year = Integer.parseInt(buf.readAscii(length));
                if (column.getLength() <= 2L) {
                    year += year >= 70 ? 1900 : 2000;
                }
                Calendar calendar = cal1;
                synchronized (calendar) {
                    cal1.clear();
                    cal1.set(year, 0, 1);
                    return new Timestamp(cal1.getTimeInMillis());
                }
            }
            case DATE: {
                if (calParam == null || calParam.getTimeZone().equals(TimeZone.getDefault())) {
                    String s = buf.readAscii(length);
                    if ("0000-00-00".equals(s)) {
                        return null;
                    }
                    return new Timestamp(Date.valueOf(s).getTime());
                }
                String[] datePart = buf.readAscii(length).split("-");
                Calendar calendar = calParam;
                synchronized (calendar) {
                    calParam.clear();
                    calParam.set(Integer.parseInt(datePart[0]), Integer.parseInt(datePart[1]) - 1, Integer.parseInt(datePart[2]));
                    return new Timestamp(calParam.getTimeInMillis());
                }
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{column.getType()}));
                }
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: 
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp;
                int begin;
                int pos = buf.pos();
                int nanoBegin = -1;
                int[] timestampsPart = new int[]{0, 0, 0, 0, 0, 0, 0};
                int partIdx = 0;
                for (begin = 0; begin < length; ++begin) {
                    byte b = buf.readByte();
                    if (b == 45 || b == 32 || b == 58) {
                        ++partIdx;
                        continue;
                    }
                    if (b == 46) {
                        ++partIdx;
                        nanoBegin = begin;
                        continue;
                    }
                    if (b < 48 || b > 57) {
                        buf.pos(pos);
                        throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{buf.readString(length), column.getType()}));
                    }
                    timestampsPart[partIdx] = timestampsPart[partIdx] * 10 + b - 48;
                }
                if (timestampsPart[0] == 0 && timestampsPart[1] == 0 && timestampsPart[2] == 0 && timestampsPart[3] == 0 && timestampsPart[4] == 0 && timestampsPart[5] == 0 && timestampsPart[6] == 0) {
                    return null;
                }
                if (nanoBegin > 0) {
                    for (begin = 0; begin < 6 - (length - nanoBegin - 1); ++begin) {
                        timestampsPart[6] = timestampsPart[6] * 10;
                    }
                }
                if (calParam == null) {
                    Calendar c = Calendar.getInstance();
                    c.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                    timestamp = new Timestamp(c.getTime().getTime());
                    timestamp.setNanos(timestampsPart[6] * 1000);
                } else {
                    Calendar calendar = calParam;
                    synchronized (calendar) {
                        calParam.clear();
                        calParam.set(timestampsPart[0], timestampsPart[1] - 1, timestampsPart[2], timestampsPart[3], timestampsPart[4], timestampsPart[5]);
                        timestamp = new Timestamp(calParam.getTime().getTime());
                        timestamp.setNanos(timestampsPart[6] * 1000);
                    }
                }
                return timestamp;
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{column.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar calParam) throws SQLDataException {
        Timestamp timestamp;
        int year;
        Calendar cal = calParam == null ? Calendar.getInstance() : calParam;
        int month = 1;
        long dayOfMonth = 1L;
        int hour = 0;
        int minutes = 0;
        int seconds = 0;
        long microseconds = 0L;
        switch (column.getType()) {
            case TIME: {
                boolean negate = buf.readByte() == 1;
                dayOfMonth = buf.readUnsignedInt();
                hour = buf.readByte();
                minutes = buf.readByte();
                seconds = buf.readByte();
                if (length > 8) {
                    microseconds = buf.readUnsignedInt();
                }
                int offset = cal.getTimeZone().getOffset(0L);
                long timeInMillis = ((24L * dayOfMonth + (long)hour) * 3600000L + (long)(minutes * 60000) + (long)(seconds * 1000) + microseconds / 1000L) * (long)(negate ? -1 : 1) - (long)offset;
                return new Timestamp(timeInMillis);
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{column.getType()}));
                }
            }
            case STRING: 
            case VARCHAR: 
            case VARSTRING: {
                String val = buf.readString(length);
                try {
                    int[] parts = LocalDateTimeCodec.parseTimestamp(val);
                    if (parts == null) {
                        return null;
                    }
                    year = parts[0];
                    month = parts[1];
                    dayOfMonth = parts[2];
                    hour = parts[3];
                    minutes = parts[4];
                    seconds = parts[5];
                    microseconds = parts[6] / 1000;
                    break;
                }
                catch (DateTimeException dte) {
                    throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Timestamp", new Object[]{val, column.getType()}));
                }
            }
            case DATE: 
            case TIMESTAMP: 
            case DATETIME: {
                if (length == 0) {
                    return null;
                }
                year = buf.readUnsignedShort();
                month = buf.readByte();
                dayOfMonth = buf.readByte();
                if (length <= 4) break;
                hour = buf.readByte();
                minutes = buf.readByte();
                seconds = buf.readByte();
                if (length <= 7) break;
                microseconds = buf.readUnsignedInt();
                break;
            }
            case YEAR: {
                year = buf.readUnsignedShort();
                if (column.getLength() > 2L) break;
                year += year >= 70 ? 1900 : 2000;
                break;
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{column.getType()}));
            }
        }
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.clear();
            cal.set(year, month - 1, (int)dayOfMonth, hour, minutes, seconds);
            timestamp = new Timestamp(cal.getTimeInMillis());
        }
        timestamp.setNanos((int)(microseconds * 1000L));
        return timestamp;
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar providedCal, Long maxLength) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        cal.setTimeInMillis(((Timestamp)value).getTime());
        if (cal.get(14) == 0) {
            encoder.writeByte(7);
            encoder.writeShort((short)cal.get(1));
            encoder.writeByte(cal.get(2) + 1);
            encoder.writeByte(cal.get(5));
            encoder.writeByte(cal.get(11));
            encoder.writeByte(cal.get(12));
            encoder.writeByte(cal.get(13));
        } else {
            encoder.writeByte(11);
            encoder.writeShort((short)cal.get(1));
            encoder.writeByte(cal.get(2) + 1);
            encoder.writeByte(cal.get(5));
            encoder.writeByte(cal.get(11));
            encoder.writeByte(cal.get(12));
            encoder.writeByte(cal.get(13));
            encoder.writeInt(cal.get(14) * 1000);
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATETIME.get();
    }
}

