/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec.list;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.DataType;
import org.mariadb.jdbc.codec.list.LongCodec;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.Codec;

public class ShortCodec
implements Codec<Short> {
    public static final ShortCodec INSTANCE = new ShortCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.VARCHAR, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Short.TYPE || type.isAssignableFrom(Short.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Short;
    }

    @Override
    public String className() {
        return Short.class.getName();
    }

    @Override
    public Short decodeText(ReadableByteBuf buffer, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeTextShort(buffer, length, column);
    }

    public short decodeTextShort(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        long result;
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case YEAR: {
                result = LongCodec.parseNotEmpty(buf, length);
                break;
            }
            case BIT: {
                result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                break;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{column.getType()}));
                }
            }
            case FLOAT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case VARCHAR: 
            case DECIMAL: 
            case ENUM: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValue();
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Short", str));
                }
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{column.getType()}));
            }
        }
        if ((long)((short)result) != result || result < 0L && !column.isSigned()) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public Short decodeBinary(ReadableByteBuf buffer, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeBinaryShort(buffer, length, column);
    }

    public short decodeBinaryShort(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        long result;
        switch (column.getType()) {
            case TINYINT: {
                result = column.isSigned() ? (long)buf.readByte() : (long)buf.readUnsignedByte();
                break;
            }
            case SMALLINT: 
            case YEAR: {
                result = column.isSigned() ? (long)buf.readShort() : (long)buf.readUnsignedShort();
                break;
            }
            case MEDIUMINT: {
                result = column.isSigned() ? (long)buf.readMedium() : (long)buf.readUnsignedMedium();
                buf.skip();
                break;
            }
            case INTEGER: {
                result = column.isSigned() ? (long)buf.readInt() : buf.readUnsignedInt();
                break;
            }
            case BIGINT: {
                result = buf.readLong();
                if (!(result < 0L & !column.isSigned())) break;
                throw new SQLDataException("int overflow");
            }
            case BIT: {
                result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                break;
            }
            case FLOAT: {
                result = (long)buf.readFloat();
                break;
            }
            case DOUBLE: {
                result = (long)buf.readDouble();
                break;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{column.getType()}));
                }
            }
            case OLDDECIMAL: 
            case VARCHAR: 
            case DECIMAL: 
            case ENUM: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValue();
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Short", str));
                }
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{column.getType()}));
            }
        }
        if ((long)((short)result) != result || result < 0L && !column.isSigned()) {
            throw new SQLDataException("Short overflow");
        }
        return (short)result;
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeShort((Short)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.SMALLINT.get();
    }
}

