/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec.list;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.DataType;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.type.Geometry;
import org.mariadb.jdbc.type.LineString;
import org.mariadb.jdbc.type.Point;
import org.mariadb.jdbc.type.Polygon;

public class PolygonCodec
implements Codec<Polygon> {
    public static final PolygonCodec INSTANCE = new PolygonCodec();

    @Override
    public String className() {
        return Polygon.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(Polygon.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Polygon;
    }

    @Override
    public Polygon decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal);
    }

    @Override
    public Polygon decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length - 4, column);
            if (geo instanceof Polygon) {
                return (Polygon)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as Polygon", geo.getClass().getName()));
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Polygon", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_PolyFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        Polygon poly = (Polygon)value;
        int length = 13;
        for (LineString ls : poly.getLines()) {
            length += 4 + ls.getPoints().length * 16;
        }
        encoder.writeLength(length);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(3);
        encoder.writeInt(poly.getLines().length);
        for (LineString ls : poly.getLines()) {
            encoder.writeInt(ls.getPoints().length);
            for (Point pt : ls.getPoints()) {
                encoder.writeDouble(pt.getX());
                encoder.writeDouble(pt.getY());
            }
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

