/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.codec.list;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.context.Context;
import org.mariadb.jdbc.client.socket.PacketWriter;
import org.mariadb.jdbc.codec.DataType;
import org.mariadb.jdbc.message.server.ColumnDefinitionPacket;
import org.mariadb.jdbc.plugin.Codec;

public class DoubleCodec
implements Codec<Double> {
    public static final DoubleCodec INSTANCE = new DoubleCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.FLOAT, DataType.DOUBLE, DataType.BIGINT, DataType.YEAR, DataType.OLDDECIMAL, DataType.DECIMAL, DataType.VARCHAR, DataType.VARSTRING, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Double.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDefinitionPacket column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Double.TYPE || type.isAssignableFrom(Double.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Double;
    }

    @Override
    public Double decodeText(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeTextDouble(buf, length, column);
    }

    public double decodeTextDouble(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case DECIMAL: 
            case YEAR: {
                return Double.parseDouble(buf.readAscii(length));
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str2 = buf.readString(length);
                try {
                    return Double.parseDouble(str2);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Double", str2));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{column.getType()}));
    }

    @Override
    public Double decodeBinary(ReadableByteBuf buf, int length, ColumnDefinitionPacket column, Calendar cal) throws SQLDataException {
        return this.decodeBinaryDouble(buf, length, column);
    }

    public double decodeBinaryDouble(ReadableByteBuf buf, int length, ColumnDefinitionPacket column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedByte();
                }
                return buf.readByte();
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return buf.readUnsignedShort();
                }
                return buf.readShort();
            }
            case MEDIUMINT: {
                double d = column.isSigned() ? (double)buf.readMedium() : (double)buf.readUnsignedMedium();
                buf.skip();
                return d;
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return buf.readUnsignedInt();
                }
                return buf.readInt();
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return buf.readLong();
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                return new BigInteger(1, bb).doubleValue();
            }
            case FLOAT: {
                return buf.readFloat();
            }
            case DOUBLE: {
                return buf.readDouble();
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return new BigDecimal(buf.readAscii(length)).doubleValue();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str2 = buf.readString(length);
                try {
                    return Double.parseDouble(str2);
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Double", str2));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(PacketWriter encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(PacketWriter encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeDouble((Double)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DOUBLE.get();
    }
}

