/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.util;

import java.util.Arrays;
import org.mariadb.jdbc.codec.Parameter;

public class ParameterList
implements Cloneable {
    Parameter<?>[] elementData;
    int length;

    public ParameterList(int defaultSize) {
        this.elementData = new Parameter[defaultSize];
        this.length = 0;
    }

    public ParameterList() {
        this.elementData = new Parameter[10];
        this.length = 0;
    }

    public Parameter<?> get(int index) {
        if (index + 1 > this.length) {
            throw new ArrayIndexOutOfBoundsException("wrong index " + index + " length:" + this.length);
        }
        return this.elementData[index];
    }

    public boolean containsKey(int index) {
        if (index >= 0 && this.length > index) {
            return this.elementData[index] == null;
        }
        return true;
    }

    public void set(int index, Parameter<?> element) {
        if (this.elementData.length < index + 1) {
            this.grow(index + 1);
        }
        this.elementData[index] = element;
        if (index + 1 > this.length) {
            this.length = index + 1;
        }
    }

    public int size() {
        return this.length;
    }

    private void grow(int minLength) {
        int currLength = this.elementData.length;
        int newLength = Math.max(currLength + (currLength >> 1), minLength);
        this.elementData = Arrays.copyOf(this.elementData, newLength);
    }

    public ParameterList clone() {
        ParameterList param = new ParameterList(this.length);
        if (this.length >= 0) {
            System.arraycopy(this.elementData, 0, param.elementData, 0, this.length);
        }
        param.length = this.length;
        return param;
    }
}

